import {EApiEntry} from 'types/EApiEntry';
import {
    IAviaFlightsToDataRequestParams,
    IAviaFlightsToDataResponse,
} from 'server/api/AviaApi/types/IAviaFlightsToData';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaFlightsToApi extends RestApiClient {
    private nationalVersion: string;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getSrcParams,
        nationalVersion,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: `${getApiHost(EApiEntry.AVIA_GATEWAY)}/landing/city-to/`,
            logger,
            requestId,
        });

        this.srcParams = getSrcParams(EApiEntry.AVIA_GATEWAY);
        this.nationalVersion = nationalVersion;
    }

    getFlightsToData({
        toSlug,
    }: IAviaFlightsToDataRequestParams): Promise<IAviaFlightsToDataResponse> {
        return this.get<IAviaFlightsToDataResponse>(
            `${toSlug}/${this.nationalVersion}/ru/`,
        );
    }
}
