import {LANG} from 'constants/langCodes';

import {EApiEntry} from 'types/EApiEntry';
import {IAviaGetFlightPageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiParams';
import {IAviaGetFlightPageApiResponse} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {IAviaGetSearchToCountryPageApiResponse} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToCountryPageApiResponse';
import {IAviaGetSearchToCountryPageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToCountryPageApiParams';
import {IAviaGetSearchToAnywherePageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToAnywherePageApiParams';
import {IAviaGetSearchToAnywherePageApiResponse} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToAnywherePageApiResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaGatewayApi extends RestApiClient {
    private nationalVersion: string;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getSrcParams,
        nationalVersion,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: getApiHost(EApiEntry.AVIA_GATEWAY),
            logger,
            requestId,
        });

        this.srcParams = getSrcParams(EApiEntry.AVIA_GATEWAY);
        this.nationalVersion = nationalVersion;
    }

    getFlightPage({
        iata,
        number,
        lang = LANG.RU,
        ...params
    }: IAviaGetFlightPageApiParams): Promise<IAviaGetFlightPageApiResponse> {
        return this.get<IAviaGetFlightPageApiResponse>(
            `/landing/flight/${iata}/${number}/${this.nationalVersion}/ru/`,
            {
                params: {
                    ...params,
                    lang,
                },
            },
        );
    }

    getSearchToCountryPage({
        from,
        to,
        dateForward,
        dateBackward,
        passengers: {adults, children, infants},
        klass,
    }: IAviaGetSearchToCountryPageApiParams): Promise<IAviaGetSearchToCountryPageApiResponse> {
        return this.get<IAviaGetSearchToCountryPageApiResponse>(
            '/landing/country/',
            {
                params: {
                    from,
                    to,
                    dateForward,
                    dateBackward,
                    adults,
                    children,
                    infants,
                    klass,
                },
            },
        );
    }

    getSearchToAnywherePage({
        from,
        dateForward,
        dateBackward,
        passengers: {adults, children, infants},
        klass,
    }: IAviaGetSearchToAnywherePageApiParams): Promise<IAviaGetSearchToAnywherePageApiResponse> {
        return this.get<IAviaGetSearchToAnywherePageApiResponse>(
            '/landing/anywhere/',
            {
                params: {
                    from,
                    dateForward,
                    dateBackward,
                    adults,
                    children,
                    infants,
                    klass,
                },
            },
        );
    }
}
