import {ISeoInfo} from 'types/hotels/common/ISeoInfo';
import {ISectionTextBlock, ITextBlock} from 'types/common/seoPages/ITextBlocks';

export enum EAviaColor {
    BLACK = 'black',
    RED = 'red',
    GREY = 'grey',
    GREEN = 'green',
    YELLOW = 'yellow',
}

export enum EAviaFlightTariffItem {
    CARRY_ON = 'carryOn',
    BAGGAGE = 'baggage',
    MILES = 'miles',
    REFUNDABLE = 'refundable',
    SEAT_SELECTION_CHECK_IN = 'seatSelectionCheckIn',
    CHANGING_CARRIAGE = 'changingCarriage',
}

export interface IAviaFlightSearchFormBlock {
    fromTitle: string;
    toTitle: string;
    fromId: string;
    toId: string;
    departureDate: string;
}

export interface IAviaBreadCrumb {
    title: string;
    link?: string;
}

interface IAviaBreadCrumbsBlock {
    items: IAviaBreadCrumb[];
}

export interface IAviaFlightDate {
    departureDate: string;
    shownDepartureDate: string;
    selected: boolean;
}

export interface IAviaFlightDatesBlock {
    items: IAviaFlightDate[];
}

export interface IAviaSegmentPoint {
    stationTitle: string;
    settlementTitle: string;
    stationCode: string;
    formattedDate: string;
    dateColor: EAviaColor;
    gate: string | null;
    gateColor: EAviaColor;
    scheduledTime: string;
    terminal: string | null;
    terminalColor: EAviaColor;
    actualTime: string | null;
    timeColor: EAviaColor;
}

export interface IAviaSegmentDuration {
    inAir: string;
    passed: number;
    total: string;
}

export interface IAviaFlightStatus {
    code: string;
    baggageCarousels: string;
    baggageCarouselsColor: EAviaColor;
    checkInDesks: string | null;
    checkInDesksColor: EAviaColor;
    departsSoon: boolean;
    text: string;
    textColor: EAviaColor;
}

export interface IAviaFlightSegment {
    arrival: IAviaSegmentPoint;
    departure: IAviaSegmentPoint;
    duration: IAviaSegmentDuration;
    lastUpdate: string;
    status: IAviaFlightStatus;
    selected: boolean;
}

export interface IAviaFlightBlock {
    segments: IAviaFlightSegment[];
}

export interface IAviaFlightTitleBlock {
    title: string;
}

export interface IAviaDisclaimerBlock {
    text: string;
}

export interface IAviaCoordinates {
    latitude: number;
    longitude: number;
}

export interface IAviaMapBlock {
    flightPointCoordinates: IAviaCoordinates[];
}

export interface IAviaUsefulLinkItem {
    data: {
        text: string;
        url: string;
    };
}

export interface IAviaUsefulLinksBlock {
    title: string;
    items: IAviaUsefulLinkItem[];
}

export interface IAviaFlightTickets {
    text: {
        title: string;
        minPriceText: string;
        text: ITextBlock[];
    };
    button: {
        text: string;
        link: string;
    };
}

export interface IAviaFlightTariffItem {
    type: EAviaFlightTariffItem;
    description: string;
    color: EAviaColor;
}

export interface IAviaFlightTariff {
    title: string;
    items: IAviaFlightTariffItem[];
}

export interface IAviaFlightTariffs {
    title: string;
    items: IAviaFlightTariff[];
}

export interface IAviaFlightBaggageRestrictions {
    title: string;
    carryOn?: IAviaFlightTariffItem;
    baggage?: IAviaFlightTariffItem;
}

export interface IAviaFlightBaggage {
    title: string;
    description: string;
    baggageRestrictions?: IAviaFlightBaggageRestrictions;
}

export interface IAviaFlightRatingItem {
    text: string;
    percent: string;
}

export interface IAviaFlightRating {
    title: string;
    items: IAviaFlightRatingItem[];
}

export interface IAviaFlightAircraftType {
    title: string;
    aircraftType: string;
}

export interface IAviaFlightAdditionalInfo {
    tariffs?: IAviaFlightTariffs;
    baggage?: IAviaFlightBaggage;
    flightRating?: IAviaFlightRating;
    aircraftType?: IAviaFlightAircraftType;
    seoText?: ISectionTextBlock;
}

export interface IAviaFlightSeoText {
    title: string;
    description: string;
}

export interface IAviaFlightBlocks {
    breadCrumbs: IAviaBreadCrumbsBlock;
    disclaimer: IAviaDisclaimerBlock;
    flight: IAviaFlightBlock;
    flightDates: IAviaFlightDatesBlock;
    flightTitle: IAviaFlightTitleBlock;
    flightSeoText: IAviaFlightSeoText;
    map: IAviaMapBlock;
    searchForm: IAviaFlightSearchFormBlock;
    usefulLinks: IAviaUsefulLinksBlock;
    tickets?: IAviaFlightTickets;
    additionalInfo: IAviaFlightAdditionalInfo;
}

export interface IAviaFlightSchemaOrgInfo {}

export interface IAviaGetFlightPageApiResponse {
    seoInfo: ISeoInfo<IAviaFlightSchemaOrgInfo>;
    blocks: IAviaFlightBlocks;
}
