import TDateRobot from 'types/common/date/TDateRobot';
import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import {TSlug} from 'types/TSlug';
import {TSettlementKey, TStationKey} from 'types/PointKey';

/**
 * Параметры запроса к ручке поиска "куда угодно" на бэкенде
 */
export interface IAviaGetSearchToAnywherePageApiParams {
    // Слаг или pointKey для станции или населенного пункта, откуда летим
    from: TSlug | TSettlementKey | TStationKey;
    // Дата "туда"
    dateForward: TDateRobot;
    // Количество пассажиров
    passengers: IPassengers;
    // Класс обслуживания
    klass: EAviaClassType;

    // Дата "обратно"
    dateBackward?: TDateRobot;
}
