import TDateRobot from 'types/common/date/TDateRobot';
import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import {TSlug} from 'types/TSlug';
import {TCountryKey, TSettlementKey, TStationKey} from 'types/PointKey';

/**
 * Параметры запроса к ручке поиска в страну на бэкенде
 */
export interface IAviaGetSearchToCountryPageApiParams {
    from: TSlug | TSettlementKey | TStationKey; // Слаг или pointKey для станции или населенного пункта, откуда летим
    to: TSlug | TCountryKey; // Слаг или pointKey страны в которую летим
    dateForward: TDateRobot; // Дата "туда"
    passengers: IPassengers; // Количество пассажиров
    klass: EAviaClassType; // Класс обслуживания

    dateBackward?: TDateRobot; // Дата "обратно"
}
