import {TInstantDateTimeType} from 'types/common/date/IDate';
import {ETernaryChoice} from 'types/common/ETernaryChoice';

export interface IAviaCovidBannerApiResponseData {
    countryId: number;
    countryTitleRu: string;
    tourism: ETernaryChoice;
    quarantine: ETernaryChoice;
    quarantineDays: number;
    visa: ETernaryChoice;
    avia: ETernaryChoice;

    /** Передаются при параметре debug=true */
    /** Время последнего обновления. */
    updatedAt?: TInstantDateTimeType;
    /** Комментарий из таблицы */
    comment?: string;
}

export interface IAviaCovidBannerApiResponseSuccess {
    status: 'ok';
    data: IAviaCovidBannerApiResponseData;
}

export interface IAviaCovidBannerApiResponseError {
    status: 'error';
}

export type TAviaCovidBannerApiResponse =
    | IAviaCovidBannerApiResponseSuccess
    | IAviaCovidBannerApiResponseError;
