import {EApiEntry} from 'types/EApiEntry';
import {IAviaPEFlightQuery} from 'server/api/AviaPassengerExperienceApi/types/IAviaPEFlightQuery';
import {IAviaPEFlightAnswer} from 'server/api/AviaPassengerExperienceApi/types/IAviaPEFlightAnswer';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaPassengerExperienceApi extends RestApiClient {
    constructor({
        httpClient,
        getApiHost,
        getSrcParams,
        logger,
        requestId,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: getApiHost(EApiEntry.PASSENGER_EXPERIENCE),
            logger,
            requestId,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.PASSENGER_EXPERIENCE);
    }

    passengerExperience({
        iata,
        when,
        lang,
        flightNumber,
    }: IAviaPEFlightQuery): Promise<IAviaPEFlightAnswer> {
        return this.get<IAviaPEFlightAnswer>(
            `/v1/flight/${iata}/${flightNumber}/${when}/`,
            {
                params: {
                    lang,
                    fields: 'flight_extras',
                },
            },
        );
    }
}
