export type TAviaPriceIndexFilters = Partial<{
    airlines: number[]; // Авиакомпании
    airport: IAviaPriceIndexAirportFilter; // Аэропорты вылета/прилета/пересадок
    time: IAviaPriceIndexTimeFilter;
    transfer: IAviaPriceIndexTransferFilter;
    withBaggage: Nullable<boolean>;
}>;

export interface IAviaPriceIndexAirportFilter {
    backwardArrival: number[];
    backwardDeparture: number[];
    backwardTransfers: number[];
    forwardArrival: number[];
    forwardDeparture: number[];
    forwardTransfers: number[];
}

export interface IAviaPriceIndexTimeFilter {
    backwardArrival: Nullable<number[]>;
    backwardDeparture: Nullable<number[]>;
    forwardArrival: Nullable<number[]>;
    forwardDeparture: Nullable<number[]>;
}

export interface IAviaPriceIndexTransferFilter {
    count: Nullable<number>;
    hasAirportChange: Nullable<boolean>;
    hasNight: Nullable<boolean>;
}
