import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {IAviaPriceIndexSearchParams} from '../types/IAviaPriceIndexSearchParams';

export function convertSearchFormToPriceIndexParams(
    searchFormParams: IAviaParams,
): IAviaPriceIndexSearchParams {
    return {
        forwardDate: searchFormParams.when,
        backwardDate: searchFormParams.return_date || null,
        fromId: Number(searchFormParams.fromId.slice(1)),
        toId: Number(searchFormParams.toId.slice(1)),
        adultsCount: Number(searchFormParams.adult_seats),
        childrenCount: Number(searchFormParams.children_seats),
        infantsCount: Number(searchFormParams.infant_seats),
    };
}
