import moment from 'moment';

import {Request} from '@yandex-data-ui/core/lib/types';
import {IAviaPriceIndexSearchInterval} from '../types/IAviaPriceIndexSearchInterval';

import {ROBOT} from 'utilities/dateUtils/formats';

export function getPriceIndexSearchInterval(
    req: Request,
): Nullable<IAviaPriceIndexSearchInterval> {
    const {startDate, endDate} = req.query;

    if (startDate && endDate) {
        const startMoment = moment(startDate, ROBOT);
        const endMoment = moment(endDate, ROBOT);

        if (startMoment.isValid() && endMoment.isValid()) {
            return {
                startDate: startMoment.format(ROBOT),
                endDate: endMoment.format(ROBOT),
            };
        }
    }

    return null;
}
