import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {
    IAviaRouteDataRequestParams,
    IAviaRouteDataResponse,
} from 'server/api/AviaApi/types/IAviaRouteData';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaRouteApi extends RestApiClient {
    private nationalVersion: string;
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getServiceTicket,
        nationalVersion,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/avia/v1/landing/`,
            logger,
            requestId,
        });

        this.nationalVersion = nationalVersion;
        this.serviceTicket = getServiceTicket('travelAPI');
    }

    getRouteData({
        fromSlug,
        toSlug,
    }: IAviaRouteDataRequestParams): Promise<IAviaRouteDataResponse> {
        return this.get<IAviaRouteDataResponse>(`route/`, {
            params: {
                fromSlug: fromSlug,
                toSlug: toSlug,
                nationalVersion: this.nationalVersion,
                lang: 'ru',
            },
        });
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
