import {IAviaRouteResponse} from 'types/avia/landing/route/IAviaRoute';
import {ELandingBlockType} from 'types/avia/landing/IAviaLanding';
import {
    EPlainTextStyle,
    ETextBlocksType,
} from 'types/common/seoPages/ITextBlocks';

import {CurrencyType} from 'utilities/currency/CurrencyType';

const aviaRouteReponse: IAviaRouteResponse = {
    seoInfo: {
        title: 'Дешевые авиабилеты Москва-Сочи',
        description: 'Дешевые авиабилеты Москва-Сочи находятся здесь',
        openGraph: {
            title: 'openGraph название страницы',
            description: 'openGraph описание страницы',
            image: 'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
            imageSize: {
                height: 200,
                width: 200,
            },
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Кто в Сочи не бывал',
                    answer: 'Красоты не видал.',
                },
                {
                    question: 'Ну Армянин!',
                    answer: 'Жизнь висит на нитке, а думает о мангале.',
                },
            ],
        },
    },
    blocks: [
        {
            type: ELandingBlockType.breadCrumbsBlock,
            data: {
                items: [
                    {
                        title: 'Авиа',
                        link: 'https://travel.yandex.ru/avia/',
                    },
                    {
                        title: 'Москва - Сочи',
                    },
                ],
            },
        },
        {
            type: ELandingBlockType.searchFormBlock,
            data: {
                title: 'Дешёвые авиабилеты Москва – Сочи находятся здесь',
                imageUrl:
                    'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
                searchFormParams: {
                    isCalendarOpen: true,
                    fromId: 'c213',
                    toId: 'c239',
                },
            },
        },
        {
            type: ELandingBlockType.dynamicsBlock,
            data: {
                title: 'Динамика цен на авиабилеты Москва – Сочи',
                description:
                    'Календарь цен позволит найти оптимальные по стоимости и времени отправления рейсы по направлению Москва –  Сочи',
                fromId: 'c213',
                toId: 'c239',
                when: '2020-12-10',
            },
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {
                title: 'Заголовк текстового блока большой',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
            },
            children: [
                {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город? Город - страшная сила. А чем больше город, тем она сильнее. Он засасывает. Только сильный может выкарабкаться.',
                            },
                        },
                    ],
                },
                {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город - ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'злая ',
                                styles: [EPlainTextStyle.bold],
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'сила. Сильный приезжает, становится ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'слабым. ',
                                styles: [EPlainTextStyle.italic],
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город забирает силу. Вот и ты ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'пропал.',
                                styles: [
                                    EPlainTextStyle.italic,
                                    EPlainTextStyle.bold,
                                ],
                            },
                        },
                    ],
                },
            ],
        },
        {
            type: ELandingBlockType.aviaCompaniesBlock,
            data: {
                title: 'Цены на перелеты из Москвы в Сочи по авиакомпаниям',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                description:
                    'Авиабилеты на прямые рейсы Москвы в Сочи вы можете купить у 14 авиакомпаний. Самые низкие цены на перелет предлагает авиакомпания Победа.',
                items: [
                    {
                        id: '26',
                        name: 'Аэрофлот',
                        when: '2020-10-12',
                        price: {
                            value: 2222,
                            currency: CurrencyType.RUB,
                        },
                        withTransfers: false,
                    },
                    {
                        id: '80',
                        name: 'Нордавиа',
                        when: '2020-10-12',
                        price: {
                            value: 1222,
                            currency: CurrencyType.RUB,
                        },
                        withTransfers: false,
                    },
                    {
                        id: '26',
                        name: 'Аэрофлот',
                        when: '2020-10-12',
                        price: {
                            value: 2222,
                            currency: CurrencyType.RUB,
                        },
                        withTransfers: false,
                    },
                    {
                        id: '80',
                        name: 'Нордавиа',
                        when: '2020-10-12',
                        price: {
                            value: 1222,
                            currency: CurrencyType.RUB,
                        },
                        withTransfers: false,
                    },
                    {
                        id: '80',
                        name: 'Нордавиа',
                        when: '2020-10-12',
                        price: {
                            value: 1222,
                            currency: CurrencyType.RUB,
                        },
                        withTransfers: false,
                    },
                ],
            },
        },
        {
            type: ELandingBlockType.closestCitiesBlock,
            data: {
                title: 'Авиабилеты из Москва в ближайшие с Сочи города',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                description: 'Рейсы до городов рядом могут быть дешевле',
                items: [
                    {
                        toSlug: 'sochi',
                        name: 'Сочи',
                        price: {
                            value: 2222,
                            currency: CurrencyType.RUB,
                        },
                    },
                    {
                        toSlug: 'moscow',
                        name: 'Москва',
                        price: {
                            value: 2222,
                            currency: CurrencyType.RUB,
                        },
                    },
                ],
            },
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {
                title: 'А едешь-то куда? В Москву!',
                navigationTitle: 'Для навигации заголовок',
            },
            children: [
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Кто в Москве не бывал',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Красоты не видал.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Ну Татарин!',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Жизнь висит на нитке, а думает о прибытке.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Это был не Татарин, а молодой. Всё классно сделал.',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Профессионал.',
                                    },
                                },
                            ],
                        },
                    },
                },
            ],
        },
        {
            type: ELandingBlockType.returnTicketBlock,
            data: {
                title: 'Обратный авиабилет из Сочи в Москву',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                items: [
                    {
                        fromSlug: 'sochi',
                        toSlug: 'moscow',
                        name: 'Сочи – Москва',
                        price: {
                            value: 2222,
                            currency: CurrencyType.RUB,
                        },
                    },
                ],
            },
        },
    ],
};

export default aviaRouteReponse;
