import {stringify} from 'query-string';

import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';
import {
    IAviaSettlementSlugRequestParams,
    IAviaSettlementSlugResponse,
} from 'server/api/AviaSettlementSlugApi/AviaSettlementSlugTypes';

export class AviaSettlementSlugApi extends RestApiClient {
    private nationalVersion: string;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getSrcParams,
        nationalVersion,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: getApiHost(EApiEntry.AVIA_GATEWAY),
            logger,
            requestId,
        });

        this.srcParams = getSrcParams(EApiEntry.AVIA_GATEWAY);
        this.nationalVersion = nationalVersion;
    }

    getSettlementSlugByGeoId({
        geoId,
    }: IAviaSettlementSlugRequestParams): Promise<IAviaSettlementSlugResponse> {
        return this.get<IAviaSettlementSlugResponse>(
            'settlement-slug-by-geo-id/',
            {
                params: {
                    geo_id: geoId,
                    national_version: this.nationalVersion,
                },
                paramsSerializer: stringify,
            },
        );
    }
}
