import {SECOND} from 'utilities/dateUtils/constants';

import {EApiEntry} from 'types/EApiEntry';
import {TAviaGetSuggestsApiResponse} from 'server/api/AviaSuggestsApi/types/TAviaGetSuggestsApiResponse';
import {IAviaGetSuggestsApiParams} from 'server/api/AviaSuggestsApi/types/IAviaGetSuggestsApiParams';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaSuggestsApi extends RestApiClient {
    private readonly nationalVersion: string;
    private readonly isSSR: boolean;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getSrcParams,
        nationalVersion,
        sendClickHouseStats,
        rootSpan,
        isSSR,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: `${getApiHost(EApiEntry.AVIA_SUGGESTS)}/v2`,
            logger,
            requestId,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.AVIA_SUGGESTS);
        this.nationalVersion = nationalVersion;
        this.isSSR = isSSR;
    }

    getSuggests(
        params: IAviaGetSuggestsApiParams,
    ): Promise<TAviaGetSuggestsApiResponse> {
        const {field, query, otherPoint, clientCity} = params;

        return this.get<TAviaGetSuggestsApiResponse>('avia', {
            params: {
                format: 'tickets',
                lang: 'ru',
                avia: true,
                have_airport_field: true,
                hidden_field: true,
                need_country: true,
                national_version: this.nationalVersion,
                field,
                query,
                client_city: clientCity,
                other_point: otherPoint,
            },
            timeout: this.isSSR ? SECOND : undefined,
        });
    }
}
