/* eslint-disable camelcase */

export interface IAviaSuggestsApiItemData {
    added: 1 | 0;
    city_title: string;
    country_title: string;
    have_airport: 1 | 0;
    have_not_hidden_airport: 1 | 0;
    hidden: 1 | 0;
    missprint: 1 | 0;
    point_code: string;
    point_key: string;
    region_title: string;
}

export enum EAviaSuggestsApiItemType {
    CITY = 0,
    AIRPORT = 1,
    COUNTRY = 2,
    SPECIAL = 3,
}

type TAviaSuggestsApiAirportItem = [
    EAviaSuggestsApiItemType.AIRPORT,
    string,
    IAviaSuggestsApiItemData,
    [],
];

type TAviaSuggestsApiCityItem = [
    EAviaSuggestsApiItemType.CITY,
    string,
    IAviaSuggestsApiItemData,
    TAviaSuggestsApiAirportItem[],
];

type TAviaSuggestsApiCountryItem = [
    EAviaSuggestsApiItemType.COUNTRY,
    string,
    IAviaSuggestsApiItemData,
    TAviaSuggestsApiCityItem[],
];

export type TAviaSuggestsApiItem =
    | TAviaSuggestsApiAirportItem
    | TAviaSuggestsApiCityItem
    | TAviaSuggestsApiCountryItem;

export type TAviaGetSuggestsApiResponse = [
    // queryString с которым ходили в саджесты
    string,
    TAviaSuggestsApiItem[],
];
