/**
 * Есть источник данных тут https://a.yandex-team.ru/arcadia/travel/avia/ticket_daemon_api/data/fare_families,
 * но от TD эти данные приходят в трансформированном виде
 */

export type TFareFamilyKey = string;
export type TVariantFareFamilyKey = Nullable<TFareFamilyKey>;
export type TVariantFareFamilyKeysByDirection = TVariantFareFamilyKey[];
export type TVariantFareFamilyKeys = [
    forward: TVariantFareFamilyKeysByDirection,
    backward: TVariantFareFamilyKeysByDirection,
];

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {IDeprecatedPrice} from 'utilities/currency/IDeprecatedPrice';

import {ECarryOnType} from './IAviaTDAnswer';

export const emptyFareFamilyKeys: TVariantFareFamilyKeys = [[], []];

export type TFareFamilies = Record<TFareFamilyKey, IFareFamily>;

/** Семество тарифов */
interface IFareFamily {
    base_class: TFareFamilyBaseClass;
    terms: TTerm[];
    tariff_group_name: Record<TTariffGroupNameLang, string>;
}

export type TFareFamilyBaseClass = 'BUSINESS' | 'ECONOMY';

export type TTariffGroupNameLang = 'ru' | 'en';

export type TTerm =
    | IFFBaggageTerm
    | IFFMilesTerm
    | IFFRefundableTerm
    | IFFChangingCarriageTerm
    | IFFCarryOnTerm
    | IFFRefundableNoShowTerm
    | IFFChangingCarriageNoShowTerm
    | IFFOpenReturnDateTerm
    | IFFDisclosureUrlTerm
    | IFFSeatSelectionCheckInTerm;

export enum EFareFamilyTermCode {
    /** багаж */
    baggage = 'baggage',
    /** мили */
    miles = 'miles',
    /** возврат */
    refundable = 'refundable',
    /** обмен */
    changingCarriage = 'changing_carriage',
    /** габариты */
    carryOn = 'carry_on',
    /** ссылка на тарифы авиакомпании */
    disclosureUrl = 'disclosure_url',
    /** выбор места */
    seatSelectionCheckIn = 'seat_selection_check_in',

    // эти не показываем
    refundableNoShow = 'refundable_no_show',
    changingCarriageNoShow = 'changing_carriage_no_show',
    openReturnDate = 'open_return_date',
}

export enum EFareFamilyAvailability {
    notAvailable = 'NOT_AVAILABLE',
    charge = 'CHARGE',
    free = 'FREE',
}

// baggage
export interface IFFBaggageTerm {
    code: EFareFamilyTermCode.baggage;
    rule: IFFBaggageTermRule;
}

export interface IFFBaggageTermRule {
    places: number;
    weight?: number;
    size?: string;
}

// miles
export interface IFFMilesTerm {
    code: EFareFamilyTermCode.miles;
    rule: IFFMilesTermRule;
}

export interface IFFMilesTermRule {
    miles: string;
}

// refundable
export interface IFFRefundableTerm {
    code: EFareFamilyTermCode.refundable;
    rule: IFFRefundableTermRule;
}

export interface IFFRefundableTermRule {
    availability: EFareFamilyAvailability;
    charge?: Partial<IDeprecatedPrice>;
    comment?: string;
}

// changing_carriage
export interface IFFChangingCarriageTerm {
    code: EFareFamilyTermCode.changingCarriage;
    rule: IFFChangingCarriageTermRule;
}

export interface IFFChangingCarriageTermRule {
    availability: EFareFamilyAvailability;
    charge?: {
        currency: CurrencyType;
        value: string;
    };
}

// carry_on
export interface IFFCarryOnTerm {
    code: EFareFamilyTermCode.carryOn;
    rule: IFFCarryOnTermRule;
}

export interface IFFCarryOnTermRule {
    /** Признак сокращенной ручной клади */
    // eslint-disable-next-line camelcase
    carry_on_size_bucket: ECarryOnType;
    comment?: string;
    weight: number;
    places: number;
    size: string;
}

// refundable_no_show
export interface IFFRefundableNoShowTerm {
    code: EFareFamilyTermCode.refundableNoShow;
}

// changing_carriage_no_show
export interface IFFChangingCarriageNoShowTerm {
    code: EFareFamilyTermCode.changingCarriageNoShow;
}

// open_return_date
export interface IFFOpenReturnDateTerm {
    code: EFareFamilyTermCode.openReturnDate;
}

// disclosure_url
export interface IFFDisclosureUrlTerm {
    code: EFareFamilyTermCode.disclosureUrl;
    rule: IFFDisclosureUrlTermRule;
}

export interface IFFDisclosureUrlTermRule {
    // eslint-disable-next-line camelcase
    special_notes: [
        {
            ru: string;
        },
    ];
}

// seat_selection_check_in
export interface IFFSeatSelectionCheckInTerm {
    code: EFareFamilyTermCode.seatSelectionCheckIn;
    rule: IFFSeatSelectionCheckInTermRule;
}

export interface IFFSeatSelectionCheckInTermRule {
    availability: EFareFamilyAvailability;
    charge?: {
        currency: string;
        value: string;
    };
}
