import {CurrencyType} from 'utilities/currency/CurrencyType';

import {IReference, IVariants, TStatus} from './IAviaTDAnswer';

/* eslint-disable camelcase */

export interface IAviaTDClickPrice {
    price: number;
    price_cpa: number;
}

export interface IAviaRedirectPageParams {
    forward: string;
    backward: string;
    partner: string;
    withBaggage: string;
    qid: string;
    start: string;
    tariff_sign: string;
    aviaBrand?: string;
}

export interface IAviaRedirectShownTariff {
    currency: CurrencyType;
    // предполагалось что будет number, но по факту сейчас приходит string
    value: string;
    price_unixtime: string;
}

export interface IAviaTDRedirectAnswer {
    cont: null;
    reference: IReference;
    url?: string;
    click_price: IAviaTDClickPrice;
    shown_tariff?: IAviaRedirectShownTariff;
    /**
     * Строка, генерируемая бэкендом. Эту строку мы записываем в лог редиректов.
     * Она нужна для того, чтобы потом сопоставить наши данные о редиректе и
     * данные о покупке на стороне партнера.
     */
    marker: string;
    variants: IVariants;
    partners: Record<string, TStatus>;
    progress: null;
    post?: Record<string, string>;
}
