import {ITrainPopularRoutesResponse} from './types/trainPopularRoutes';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IBunkerFeatureFlagsResponse} from 'server/services/BunkerService/utilities/prepareBunkerFeatureFlagsResponse';

import {IDependencies} from '../../getContainerConfig';

export class BunkerApi extends RestApiClient {
    constructor({
        logger,
        requestId,
        getApiHost,
        getSrcParams,
        httpClient,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.BUNKER)}/v1`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.BUNKER);
    }

    getTrainPopularRoutes(): Promise<ITrainPopularRoutesResponse> {
        return this.get<ITrainPopularRoutesResponse>('/cat/', {
            params: {
                node: '/travel/trains/popular-routes',
            },
        });
    }

    getFeatureFlags(): Promise<IBunkerFeatureFlagsResponse> {
        return this.get<IBunkerFeatureFlagsResponse>('/cat/', {
            params: {
                node: '/travel/feature-flags',
            },
        });
    }
}
