import {IBusesGetPopularDirectionsApiParams} from 'server/api/BusesApi/types/IBusesGetPopularDirectionsApiParams';
import {IBusesGetPopularDirectionsApiResponse} from 'server/api/BusesApi/types/IBusesGetPopularDirectionsApiResponse';
import {IBusesGetRideApiParams} from 'server/api/BusesApi/types/IBusesGetRideApiParams';
import {IBusesGetRideApiResponse} from 'server/api/BusesApi/types/IBusesGetRideApiResponse';
import {IBusesGetSegmentsApiParams} from 'server/api/BusesApi/types/IBusesGetSegmentsApiParams';
import {IBusesGetSegmentsApiResponse} from 'server/api/BusesApi/types/IBusesGetSegmentsApiResponse';
import {IBusesGetCalendarApiParams} from 'server/api/BusesApi/types/IBusesGetCalendarApiParams';
import {TBusesGetCalendarApiResponse} from 'server/api/BusesApi/types/TBusesGetCalendarApiResponse';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

const BUSES_API_PRESTABLE =
    'https://prestable.backend.internal.bus.yandex.net/api';

export class BusesApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
        isE2E,
        appConfig,
    }: IDependencies) {
        super({
            baseURL:
                appConfig.env !== 'production' && isE2E
                    ? BUSES_API_PRESTABLE
                    : getApiHost(EApiEntry.BUSES),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.BUSES);
    }

    getPopularDirections(
        params: IBusesGetPopularDirectionsApiParams,
    ): Promise<IBusesGetPopularDirectionsApiResponse> {
        return this.get<IBusesGetPopularDirectionsApiResponse>('/popular', {
            params,
            convertResponseKeysToCamelCase: true,
        });
    }

    getSegments(
        params: IBusesGetSegmentsApiParams,
    ): Promise<IBusesGetSegmentsApiResponse> {
        return this.get<IBusesGetSegmentsApiResponse>('/search', {
            params,
            convertResponseKeysToCamelCase: true,
            withStatus: true,
        });
    }

    getCalendar(
        params: IBusesGetCalendarApiParams,
    ): Promise<TBusesGetCalendarApiResponse> {
        return this.get<TBusesGetCalendarApiResponse>('/calendar', {
            params,
        });
    }

    getRide(params: IBusesGetRideApiParams): Promise<IBusesGetRideApiResponse> {
        return this.get<IBusesGetRideApiResponse>('/ride', {
            params,
            convertResponseKeysToCamelCase: true,
        });
    }
}
