import {IBusesGetSuggestsApiParams} from 'server/api/BusesGeoApi/types/IBusesGetSuggestsApiParams';
import {IBusesGetSuggestsApiResponse} from 'server/api/BusesGeoApi/types/IBusesGetSuggestsApiResponse';
import {IBusesGetGeoPointApiParams} from 'server/api/BusesGeoApi/types/IBusesGetGeoPointApiParams';
import {IBusesGetGeoPointsApiResponse} from 'server/api/BusesGeoApi/types/IBusesGetGeoPointsApiResponse';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class BusesGeoApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.BUSES_GEO),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.BUSES_GEO);
    }

    getSuggests(
        params: IBusesGetSuggestsApiParams,
    ): Promise<IBusesGetSuggestsApiResponse> {
        return this.get<IBusesGetSuggestsApiResponse>('/points/suggests', {
            params: {
                format: 'new',
                ...params,
            },
            convertResponseKeysToCamelCase: true,
        });
    }

    getGeoPoints(
        params: IBusesGetGeoPointApiParams,
    ): Promise<IBusesGetGeoPointsApiResponse> {
        return this.get<IBusesGetGeoPointsApiResponse>('/points', {
            params: {
                from: 'serp-resolve',
                where: `code:${params.pointsIds.join(',')}`,
            },
            convertResponseKeysToCamelCase: true,
        });
    }
}
