import {CommonHeaders} from 'server/constants/headers';
import {CREATE_RIDE_OFFER_TIMEOUT} from './constants';

import {EApiEntry} from 'types/EApiEntry';
import {IBusesGetDirectionApiParams} from './types/IBusesGetDirectionApiParams';
import {IBusesGetDirectionApiResponse} from './types/IBusesGetDirectionApiResponse';
import {IBusesCreateRideOfferApiParams} from './types/IBusesCreateRideOfferApiParams';
import {TBusesCreateRideOfferApiResponse} from './types/TBusesCreateRideOfferApiResponse';
import {
    IBusesGetTestContextRequestParams,
    IBusesGetTestContextResponse,
} from './types/IBusesGetTestContext';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class BusesTravelApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        getServiceTicket,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.TRAVEL),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TRAVEL);
        this.serviceTicket = getServiceTicket('travelAPI');
    }

    createRideOffer(
        params: IBusesCreateRideOfferApiParams,
    ): Promise<TBusesCreateRideOfferApiResponse> {
        return this.post<TBusesCreateRideOfferApiResponse>(
            '/buses/v1/create_ride_offer',
            params,
            {
                timeout: CREATE_RIDE_OFFER_TIMEOUT,
            },
        );
    }

    getBusesDirection(
        params: IBusesGetDirectionApiParams,
    ): Promise<IBusesGetDirectionApiResponse> {
        return this.get('/buses/v1/direction', {params});
    }

    getTestContext(
        params: IBusesGetTestContextRequestParams,
    ): Promise<IBusesGetTestContextResponse> {
        return this.get<IBusesGetTestContextResponse>(
            '/test_context/v1/bus_token',
            {
                params,
            },
        );
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
