import {EBusesDirectionBlock} from 'projects/buses/constants/direction/EBusesDirectionBlock';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {IBusesGetDirectionApiResponse} from '../types/IBusesGetDirectionApiResponse';

export const directionInfo: IBusesGetDirectionApiResponse = {
    context: {
        from: {
            country: {
                code: 'RU',
                title: 'Россия',
            },
            key: 'c213',
            region: {title: 'Москва и Московская область'},
            settlement: {title: 'moscow'},
            slug: 'moscow',
            timezone: 'Europe/Moscow',
            title: {
                nominativeCase: 'Москва',
                genitiveCase: 'Москвы',
                locativeCase: '',
                accusativeCase: 'Москву',
            },
        },
        to: {
            country: {
                code: 'RU',
                title: 'Россия',
            },
            key: 'c193',
            region: {title: 'Воронежская область'},
            settlement: {title: 'Воронеж'},
            slug: 'voronezh',
            timezone: 'Europe/Moscow',
            title: {
                nominativeCase: 'Воронеж',
                genitiveCase: 'Воронежа',
                locativeCase: '',
                accusativeCase: 'Воронеж',
            },
        },
        distance: 466.73056019004093,
        errors: [],
    },
    blocks: [
        {
            type: EBusesDirectionBlock.BUSES_SEGMENTS,
            data: {
                when: '2023-03-28',
                segments: [
                    {
                        carrierCode: '423E9325D5EC0062F3CAFFAE1DABFA7F',
                        freeSeats: 48,
                        id: 'busfor:eyJyaWRlX2RhdGUiOiAiMjAyMi0wNi0xNyIsICJyaWRlX3NpZCI6ICJRbE5HZEdWemRHRm5aVzUwZmpJME5EUXpNSDQwTVRJek5uNHhPekV3Zm40d2ZrVTFSVUpEUmtZMU16WkROakZEUVRaQ01EUTBPRFJHTnpGRU5EY3hRelkxIn0=',
                        price: {
                            currency: CurrencyType.RUB,
                            value: 1000,
                        },
                        arrivalTime: '2033-01-30T11:30:30',
                        departureTime: '2033-02-30T11:30:30',
                        carrierName: 'RU "Горизон-Тур" ООО (АТП)',
                        duration: 28800000,
                        from: {
                            timezone: 'Europe/Moscow',
                            title: 'Автовокзал "Щелковский", метро Щелковская; шоссе Щелковское; дом 75',
                            coordinates: {
                                lat: 55.621057,
                                lon: 37.421688,
                            },
                        },
                        to: {
                            timezone: 'Europe/Moscow',
                            title: 'Автовокзал "Центральный", проспект Московский; дом 17',
                            coordinates: {
                                lat: 51.6925616730693,
                                lon: 39.1812742870328,
                            },
                        },
                    },
                ],
            },
        },
        {
            type: EBusesDirectionBlock.BUSES_CROSSLINK,
            data: {
                crossLinks: [
                    {
                        toKey: 'c193',
                        toSlug: 'voronezh',
                        toTitle: 'Воронеж',
                        fromKey: 'c10713',
                        fromSlug: 'yelets',
                        fromTitle: 'Елец',
                    },
                    {
                        toKey: 'c213',
                        toSlug: 'moscow',
                        toTitle: 'Москва',
                        fromKey: 'c10713',
                        fromSlug: 'yelets',
                        fromTitle: 'Елец',
                    },
                    {
                        toKey: 'c10675',
                        toSlug: 'borisoglebsk',
                        toTitle: 'Борисоглебск',
                        fromKey: 'c193',
                        fromSlug: 'voronezh',
                        fromTitle: 'Воронеж',
                    },
                    {
                        toKey: 'c10676',
                        toSlug: 'buturlinovka',
                        toTitle: 'Бутурлиновка',
                        fromKey: 'c193',
                        fromSlug: 'voronezh',
                        fromTitle: 'Воронеж',
                    },
                    {
                        toKey: 'c10681',
                        toSlug: 'rossosh',
                        toTitle: 'Россошь',
                        fromKey: 'c193',
                        fromSlug: 'voronezh',
                        fromTitle: 'Воронеж',
                    },
                    {
                        toKey: 'c4',
                        toSlug: 'belgorod',
                        toTitle: 'Белгород',
                        fromKey: 'c193',
                        fromSlug: 'voronezh',
                        fromTitle: 'Воронеж',
                    },
                    {
                        toKey: 'c9',
                        toSlug: 'lipetsk',
                        toTitle: 'Липецк',
                        fromKey: 'c193',
                        fromSlug: 'voronezh',
                        fromTitle: 'Воронеж',
                    },
                    {
                        toKey: 'c10649',
                        toSlug: 'stariy-oskol',
                        toTitle: 'Старый Оскол',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c10679',
                        toSlug: 'ostrogozhsk',
                        toTitle: 'Острогожск',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c10680',
                        toSlug: 'pavlovsk-voronezh-district',
                        toTitle: 'Павловск',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c10681',
                        toSlug: 'rossosh',
                        toTitle: 'Россошь',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c10713',
                        toSlug: 'yelets',
                        toTitle: 'Елец',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c2',
                        toSlug: 'saint-petersburg',
                        toTitle: 'Санкт-Петербург',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c39',
                        toSlug: 'rostov-on-don',
                        toTitle: 'Ростов-на-Дону',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c4',
                        toSlug: 'belgorod',
                        toTitle: 'Белгород',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c9',
                        toSlug: 'lipetsk',
                        toTitle: 'Липецк',
                        fromKey: 'c213',
                        fromSlug: 'moscow',
                        fromTitle: 'Москва',
                    },
                    {
                        toKey: 'c193',
                        toSlug: 'voronezh',
                        toTitle: 'Воронеж',
                        fromKey: 'c9',
                        fromSlug: 'lipetsk',
                        fromTitle: 'Липецк',
                    },
                    {
                        toKey: 'c213',
                        toSlug: 'moscow',
                        toTitle: 'Москва',
                        fromKey: 'c9',
                        fromSlug: 'lipetsk',
                        fromTitle: 'Липецк',
                    },
                ],
            },
        },
    ],
};
