import {HOUR} from 'utilities/dateUtils/constants';

import {TBusesCreateRideOfferApiResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';
import {EGender} from 'types/common/document/EGender';
import {
    EBusesPlaceStatus,
    EBusesPlaceType,
    EBusesTicketType,
    IBusesPlace,
} from 'types/buses/booking/IBusesBookParams';
import {
    EPointType,
    ERegisterType,
    IBusesRide,
} from 'types/buses/booking/IBusesRide';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

const RIDE_MOCK: IBusesRide = {
    id: 'busfor:eyJyaWRlX2RhdGUiOiAiMjAyMS0xMi0wOSIsICJyaWRlX3NpZCI6ICJRbE5HZEdWemRHRm5aVzUwZmpJME5EUXpNSDQwTVRJek5uNHhPekV3Zm40d2ZrVTFSVUpEUmtZMU16WkROakZEUVRaQ01EUTBPRFJHTnpGRU5EY3hRelkxIn0=',
    departure: '2021-12-09T10:30:00Z',
    arrival: '2021-12-09T18:30:00Z',
    duration: 11 * HOUR,
    titlePointFrom: {
        supplierDescription:
            'Автовокзал "Щелковский", метро Щелковская; шоссе Щелковское; дом 75',
        type: EPointType.STATION,
        title: 'Москва',
        timezone: 'Europe/Moscow',
    },
    titlePointTo: {
        supplierDescription:
            'Автовокзал "Центральный", проспект Московский; дом 17',
        type: EPointType.STATION,
        title: 'Воронеж',
        timezone: 'Europe/Moscow',
    },
    pointFrom: {
        supplierDescription:
            'Автовокзал "Щелковский", метро Щелковская; шоссе Щелковское; дом 75',
    },
    pointTo: {
        supplierDescription:
            'Автовокзал "Центральный", проспект Московский; дом 17',
    },
    busDescription: 'Mercedes 0350 (СВ)',
    routeNumber: 'MD_TEST - 982  Москва - Тамань',
    benefits: [],
    carrier: {
        registerType: ERegisterType.COMPANY,
        registerNumber: '',
        name: 'RU "Горизон-Тур" ООО (АТП)',
        legalName: 'RU "Горизон-Тур" ООО (АТП)',
        legalAddress: 'г Москва, ул Елецкая, д 26',
        actualAddress: 'г Москва, ул Елецкая, д 26',
        taxationNumber: '7724762454',
        timetable: 'пн-пт: 10:00–18:00',
    },
    supplier: {
        registerType: ERegisterType.COMPANY,
        registerNumber: '',
        name: 'RU "Горизон-Тур" ООО (АТП)',
        legalName: 'RU "Горизон-Тур" ООО (АТП)',
        legalAddress: 'г Москва, ул Елецкая, д 26',
        actualAddress: 'г Москва, ул Елецкая, д 26',
        taxationNumber: '7724762454',
        timetable: 'пн-пт: 10:00–18:00',
    },
    freeSeats: 49,
    ticketLimit: 5,
    refundConditions:
        'Более чем за 2 ч., до отправления рейса Удерживается при возврате: 5% тарифа; 100% сервисного; 100% сервисного №2\nМенее чем за 2 ч., до отправления рейса Удерживается при возврате: 15% тарифа; 100% сервисного; 100% сервисного №2\nВозврат маршрутной квитанции в случае опоздания к отправлению транспортного средства в течение 3 часов Удерживается при возврате: 25% тарифа; 100% сервисного; 100% сервисного №2\nПо объективным причинам,(болезнь, несчастный случай), при наличии подтверждающих документов, менее чем за 3 дн., после отправления рейса Удерживается при возврате: 25% тарифа; 100% сервисного №2; 100% сервисного',
};

const PLACES_MAP: IBusesPlace[] = [
    {
        x: 0,
        y: 0,
        id: '3',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 1,
        y: 0,
        id: '7',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 2,
        y: 0,
        id: '11',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 3,
        y: 0,
        id: '15',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 4,
        y: 0,
        id: '19',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 5,
        y: 0,
        id: '23',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 6,
        y: 0,
        id: '27',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 7,
        y: 0,
        id: '31',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 8,
        y: 0,
        id: '35',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 9,
        y: 0,
        id: '39',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 10,
        y: 0,
        id: '43',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 11,
        y: 0,
        id: '47',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 12,
        y: 0,
        id: '0',
        type: EBusesPlaceType.PASSAGE,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 13,
        y: 0,
        id: '0',
        type: EBusesPlaceType.PASSAGE,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 0,
        y: 1,
        id: '4',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 1,
        y: 1,
        id: '8',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 2,
        y: 1,
        id: '12',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 3,
        y: 1,
        id: '16',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 4,
        y: 1,
        id: '20',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 5,
        y: 1,
        id: '24',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 6,
        y: 1,
        id: '28',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 7,
        y: 1,
        id: '32',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 8,
        y: 1,
        id: '36',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 9,
        y: 1,
        id: '40',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 10,
        y: 1,
        id: '44',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 11,
        y: 1,
        id: '48',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 12,
        y: 1,
        id: '0',
        type: EBusesPlaceType.PASSAGE,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 13,
        y: 1,
        id: '0',
        type: EBusesPlaceType.PASSAGE,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 0,
        y: 2,
        id: '2',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 1,
        y: 2,
        id: '6',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 2,
        y: 2,
        id: '10',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 3,
        y: 2,
        id: '14',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 4,
        y: 2,
        id: '18',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 5,
        y: 2,
        id: '22',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 6,
        y: 2,
        id: '26',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 7,
        y: 2,
        id: '30',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 8,
        y: 2,
        id: '34',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 9,
        y: 2,
        id: '38',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 10,
        y: 2,
        id: '42',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 11,
        y: 2,
        id: '46',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 12,
        y: 2,
        id: '50',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 13,
        y: 2,
        id: '54',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 0,
        y: 3,
        id: '1',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 1,
        y: 3,
        id: '5',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 2,
        y: 3,
        id: '9',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 3,
        y: 3,
        id: '13',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 4,
        y: 3,
        id: '17',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 5,
        y: 3,
        id: '21',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 6,
        y: 3,
        id: '25',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 7,
        y: 3,
        id: '29',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 8,
        y: 3,
        id: '33',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 9,
        y: 3,
        id: '37',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 10,
        y: 3,
        id: '41',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 11,
        y: 3,
        id: '45',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.FREE,
    },
    {
        x: 12,
        y: 3,
        id: '49',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
    {
        x: 13,
        y: 3,
        id: '53',
        type: EBusesPlaceType.SEAT,
        status: EBusesPlaceStatus.OCCUPIED,
    },
];
// const PLACES_MAP_WITH_DRIVER = [
//     {
//         x: 0,
//         y: 0,
//         id: '3',
//         type: EBusesPlaceType.DRIVER,
//         status: EBusesPlaceStatus.OCCUPIED,
//     },
//     ...PLACES_MAP.slice(1),
// ];
const SEATS_BASED_ON_MAP = PLACES_MAP.map(placeMap => placeMap.id);
// const SEATS: string[] = [
//     '1',
//     '2',
//     '3',
//     '5',
//     '6',
//     '7',
//     '8',
//     '9',
//     '10',
//     '11',
//     '12',
//     '13',
//     '14',
//     '15',
//     '17',
//     '18',
// ];

const RIDE_OFFER_MOCK_200: TBusesCreateRideOfferApiResponse = {
    ride: RIDE_MOCK,
    bookParams: {
        placesMap: PLACES_MAP,
        seats: SEATS_BASED_ON_MAP,
        citizenships: [],
        documentTypes: [
            EDocumentType.RU_NATIONAL_PASSPORT,
            EDocumentType.RU_BIRTH_CERTIFICATE,
            EDocumentType.RU_FOREIGN_PASSPORT,
            EDocumentType.OTHER,
        ],
        genders: [EGender.MALE, EGender.FEMALE],
        ticketTypes: [
            {
                type: EBusesTicketType.FULL,
                fare: {
                    total: {
                        value: 125.4,
                        currency: CurrencyType.RUB,
                    },
                    ticket: {
                        value: 114,
                        currency: CurrencyType.RUB,
                    },
                    supplierFee: {
                        value: 0,
                        currency: CurrencyType.RUB,
                    },
                    yandexFee: {
                        value: 11.4,
                        currency: CurrencyType.RUB,
                    },
                },
            },
            {
                type: EBusesTicketType.CHILD,
                fare: {
                    total: {
                        value: 60,
                        currency: CurrencyType.RUB,
                    },
                    ticket: {
                        value: 55,
                        currency: CurrencyType.RUB,
                    },
                    supplierFee: {
                        value: 0,
                        currency: CurrencyType.RUB,
                    },
                    yandexFee: {
                        value: 5,
                        currency: CurrencyType.RUB,
                    },
                },
            },
            {
                type: EBusesTicketType.BAGGAGE,
                fare: {
                    total: {
                        value: 20,
                        currency: CurrencyType.RUB,
                    },
                    ticket: {
                        value: 18,
                        currency: CurrencyType.RUB,
                    },
                    supplierFee: {
                        value: 0,
                        currency: CurrencyType.RUB,
                    },
                    yandexFee: {
                        value: 2,
                        currency: CurrencyType.RUB,
                    },
                },
            },
        ],
    },
    offerId: 'testOfferId',
    label: 'testLabel',
    error: undefined,
};

export default RIDE_OFFER_MOCK_200;
