export enum EBusesBookOutcome {
    BBO_UNKNOWN = 'BBO_UNKNOWN',
    BBO_SUCCESS = 'BBO_SUCCESS',
    BBO_FAILURE = 'BBO_FAILURE',
}

export enum EBusesConfirmOutcome {
    BCO_UNKNOWN = 'BCO_UNKNOWN',
    BCO_SUCCESS = 'BCO_SUCCESS',
    BCO_FAILURE = 'BCO_FAILURE',
}

export enum EBusesRefundInfoOutcome {
    BRIO_UNKNOWN = 'BRIO_UNKNOWN',
    BRIO_SUCCESS = 'BRIO_SUCCESS',
    BRIO_FAILURE = 'BRIO_FAILURE',
}

export enum EBusesRefundOutcome {
    BRO_UNKNOWN = 'BRO_UNKNOWN',
    BRO_SUCCESS = 'BRO_SUCCESS',
    BRO_FAILURE = 'BRO_FAILURE',
}

export interface IBusesGetTestContextRequestParams {
    /**
     * Результат создания бронирования
     */
    bookOutcome: EBusesBookOutcome;

    /**
     * Результат подтверждения бронирования
     */
    confirmOutcome: EBusesConfirmOutcome;

    /**
     * Результат получения стоимости к возврату
     */
    refundInfoOutcome: EBusesRefundInfoOutcome;

    /**
     * Результат проведения возврата
     */
    refundOutcome: EBusesRefundOutcome;

    /**
     * Секунд до автоотмены брони по таймауту
     */
    expireAfterSeconds?: number;
}

export interface IBusesGetTestContextResponse {
    testContextToken: string;
}
