import {CommonHeaders} from 'server/constants/headers';
import {SECOND} from 'utilities/dateUtils/constants';

import {
    ICrossLinksApiResponse,
    ICrossLinksApiParams,
} from 'server/api/CommonApi/types/CrossLinks';
import {EApiEntry} from 'types/EApiEntry';
import {IGetUserYandexPlusInfoResponse} from 'server/api/CommonApi/types/YandexPlus';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class CommonApi extends RestApiClient {
    private readonly serviceTicket: string;
    private readonly isSSR: boolean;

    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        requestId,
        rootSpan,
        getServiceTicket,
        isSSR,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.TRAVEL),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.serviceTicket = getServiceTicket('travelAPI');
        this.isSSR = isSSR;
    }

    getCrossLinks(
        params: ICrossLinksApiParams,
    ): Promise<ICrossLinksApiResponse> {
        return this.get<ICrossLinksApiResponse>('/common/v1/crosslinks', {
            params: {
                type: params.type,
            },
            convertResponseKeysToCamelCase: true,
            timeout: this.isSSR ? SECOND : undefined,
        });
    }

    getUserYandexPlusInfo(): Promise<IGetUserYandexPlusInfoResponse> {
        return this.get<IGetUserYandexPlusInfoResponse>(
            '/common/v1/get_user_yandex_plus_info',
            {
                convertResponseKeysToCamelCase: true,
                timeout: this.isSSR ? SECOND : undefined,
            },
        );
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = request.timeout ?? 25 * SECOND;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
        };
    }
}
