import {EProjectName} from 'constants/common';

import IPrice from 'types/common/price/IPrice';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';

export interface ICrossLinksApiParams {
    type: EProjectName;
}

export interface ICrossLinksApiResponse {
    recipes: IRecipeBlock;
    crossLinks: ICrossLinkBlock[];
}

export interface IRecipeBlock {
    directions: IDirection[];
}

export interface ICrossLinkBlock extends IRecipeBlock {
    title: string;
}

export interface IDirection {
    from?: IDirectionDestination;
    to: IDirectionDestination;
    minPrice?: IPrice;
    imageUrl: string;
}

export interface IDirectionDestination {
    slug: TGeoRegionSlug;
    linguistics: {
        nominativeCase: string;
        genitiveCase: string;
        accusativeCase: string;
    };
}
