/**
 * Внутреннее состояние заказа для управления процессом бронирования.
 */
enum EGenericOrderState {
    NEW = 'NEW',
    IN_PROGRESS = 'IN_PROGRESS',
    RESERVED = 'RESERVED',
    STARTING_PAYMENT = 'STARTING_PAYMENT',
    WAITING_PAYMENT = 'WAITING_PAYMENT',
    PAYMENT_FAILED = 'PAYMENT_FAILED',
    CONFIRMED = 'CONFIRMED',
    CANCELLED = 'CANCELLED',
    WAITING_REFUND = 'WAITING_REFUND',
    REFUNDED = 'REFUNDED',
    WAITING_RESERVATION = 'WAITING_RESERVATION',
}

export default EGenericOrderState;

export function isGenericOrderState(
    candidate: string,
): candidate is EGenericOrderState {
    return Object.values(EGenericOrderState).some(type => type === candidate);
}
