import {Overwrite} from 'utility-types';

import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';
import {IBusesOrderPassenger} from 'types/buses/order/IBusesOrderPassenger';
import {EGender} from 'types/common/document/EGender';

export interface IBusesCreateOrderPassengerParams
    extends Overwrite<
        IBusesOrderPassenger,
        {
            sex: EGender;
            citizenship: number;
        }
    > {}

export interface IBusesCreateOrderTicketParams
    extends Pick<IBusesOrderTicket, 'ticketType' | 'seat'> {
    passenger: IBusesCreateOrderPassengerParams;
}

export interface ICreateBusesServiceParams {
    offerId: string;
    busTestContextToken?: string;
    tickets: IBusesCreateOrderTicketParams[];
}
