import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';
import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';
import {IOrderPriceInfo} from 'server/api/HotelsBookAPI/types/IOrder';
import IPaymentInfo from 'server/api/GenericOrderApi/types/common/IPaymentInfo';
import IContactInfo from 'server/api/GenericOrderApi/types/common/IContactInfo';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import {TGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import ECancellationReason from 'server/api/GenericOrderApi/types/common/ECancellationReason';

export interface IGenericOrderInfo {
    /**
     * Внутренный технический идентификатор заказа. Используется в ссылках и вызовах API.
     */
    id: string;

    /**
     * Идентификатор заказа для отображения пользователю. Поддерживается в некоторых методах API.
     */
    prettyId: string;

    state: EGenericOrderState | string;

    displayState: EDisplayOrderState;

    /**
     * Срок истечения брони по неоформленному заказу.
     */
    expiresAt?: string;

    /**
     * Дата и время исполнения заказа.
     */
    servicedAt?: string;

    services: TGenericService[];

    orderPriceInfo: IOrderPriceInfo;

    payment: IPaymentInfo | null;

    /**
     * Контакты для связи. Используются в том числе и для получения доступа в заказу.
     */
    contactInfo: IContactInfo;

    /**
     * Информация о возврате для всего заказа
     */
    refundPartInfo: IRefundPartInfo | null;

    /**
     * Время, в которое нужно обновить заказ, чтобы показать актуальные данные
     */
    reloadOrderAt: string | null;

    /**
     * Причина отмены заказа.
     * Отображается пользователю когда заказ переходит в состояние CANCELLED в виде
     * сообщения типа "время брони истекло"
     */
    cancellationReason?: ECancellationReason;

    /**
     * id поездки, к которой привязан заказ. Если поездки еще нет, то отсутствует
     */
    tripId?: string | null;
}
