import {IBusesServiceInfo} from 'server/api/GenericOrderApi/types/common/service/IBusesServiceInfo/IBusesServiceInfo';

import EServiceType from './EServiceType';
import EServiceState from './EServiceState';
import {IRefundPartInfo} from './refund/IRefundPartInfo';
import IHotelServiceInfo from './service/IHotelServiceInfo/IHotelServiceInfo';
import ITrainServiceInfo from './service/ITrainServiceInfo/ITrainServiceInfo';

interface ICommonGenericService {
    id: string;

    serviceType: EServiceType;
    state: EServiceState;

    /**
     * Информация о возврате части услуги
     */
    refundPartInfo: IRefundPartInfo | null;
}

export interface ITrainGenericService extends ICommonGenericService {
    serviceType: EServiceType.TRAIN;
    trainInfo: ITrainServiceInfo;
}

export interface IHotelGenericService extends ICommonGenericService {
    serviceType: EServiceType.HOTEL;
    hotelInfo: IHotelServiceInfo;
}

export interface IBusesGenericService extends ICommonGenericService {
    serviceType: EServiceType.BUS;
    busInfo: IBusesServiceInfo;
}

export type TGenericService =
    | ITrainGenericService
    | IHotelGenericService
    | IBusesGenericService;
