import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';

import IPrice from 'utilities/currency/PriceInterface';

import ITrainTicket from './ITrainTicket';
import ITrainInsurance from './ITrainInsurance';

export default interface ITrainPassenger {
    ticket: ITrainTicket | null;
    docId: string;
    docType: TRAINS_DOCUMENT_TYPES;
    citizenship: string;
    firstName: string;
    lastName: string;
    patronymic: string;
    age: number;
    birthDate: string;
    sex: 'M' | 'F';
    customerId: number;
    insurance: ITrainInsurance | null;
    nonRefundableTariff: boolean;
    total: IPrice | null;
    refundPartInfo: IRefundPartInfo | null;
}
