import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';
import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';

import IPrice from 'utilities/currency/PriceInterface';

import ITrainTicketPayment from './ITrainTicketPayment';
import ITrainTariffInfo from './ITrainTariffInfo';
import ITrainPlaceWithType from './ITrainPlaceWithType';

export default interface ITrainTicket {
    places: ITrainPlaceWithType[];
    tariffInfo: ITrainTariffInfo | null;
    rzhdStatus: TrainsOrderInfoTicketRzhdStatus | null;
    amount: IPrice;
    rawTariffTitle: string;
    bookedTariffCode: TrainBookedTariffCode | null;
    payment: ITrainTicketPayment;
    blankId: number;
    discountDenied: boolean;
    canChangeElectronicRegistrationTill: string | null;
    canReturnTill: string | null;
    pending: boolean;
}
