import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {TrainsInsuranceStatus} from 'server/api/TrainsBookingApi/types/TrainsInsuranceStatus';
import {EDirection} from 'types/common/EDirection';
import {TrainsOrderCompartmentGender} from 'server/api/TrainsBookingApi/types/TrainsOrderCompartmentGender';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';
import {TTrainApiOrderError} from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/TTrainOrderError/TTrainApiOrderError';

import IErrorInfo from './IErrorInfo/IErrorInfo';
import ITrainWarningInfo from './ITrainWarningInfo/ITrainWarningInfo';
import ITrainPassenger from './ITrainPassenger/ITrainPassenger';
import ITrainRailwayStation from './ITrainRailwayStation';
import ITrainInfo from './ITrainInfo';

export default interface ITrainServiceInfo {
    error: (IErrorInfo & TTrainApiOrderError) | null;
    insuranceStatus: TrainsInsuranceStatus;

    direction: EDirection;
    segmentIndex: number;

    partnerOrderId: number;
    reservationNumber?: string;
    stationFrom: ITrainRailwayStation & ITrainsStation;
    stationTo: ITrainRailwayStation & ITrainsStation;
    trainInfo: ITrainInfo;
    carType: TRAIN_COACH_TYPE;
    compartmentGender: TrainsOrderCompartmentGender | null;
    arrival: string;
    departure: string;
    partner: string;
    carNumber: string;
    specialNotice: string;
    warnings: ITrainWarningInfo[] | null;
    twoStorey: boolean;
    coachOwner: string;
    companyTitle?: string;
    passengers: ITrainPassenger[];
    rebookingAvailable: boolean;
}
