enum ETrainWarningMessageCode {
    ALMOST_SIX_HOURS_TO_DEPARTURE = 'ALMOST_SIX_HOURS_TO_DEPARTURE',
    ELECTRONIC_REGISTRATION_ALMOST_EXPIRED = 'ELECTRONIC_REGISTRATION_ALMOST_EXPIRED',
    ELECTRONIC_REGISTRATION_EXPIRED = 'ELECTRONIC_REGISTRATION_EXPIRED',
    INSURANCE_AUTO_RETURN = 'INSURANCE_AUTO_RETURN',
    LESS_THEN_SIX_HOURS_TO_DEPARTURE = 'LESS_THEN_SIX_HOURS_TO_DEPARTURE',
    TICKETS_TAKEN_AWAY = 'TICKETS_TAKEN_AWAY',
    TRAIN_ALMOST_LEFT_DEPARTURE_STATION = 'TRAIN_ALMOST_LEFT_DEPARTURE_STATION',
    TRAIN_LEFT_DEPARTURE_STATION = 'TRAIN_LEFT_DEPARTURE_STATION',
    TRAIN_LEFT_START_STATION = 'TRAIN_LEFT_START_STATION',
    HAS_NON_REFUNDABLE_TARIFF = 'HAS_NON_REFUNDABLE_TARIFF',
}

export default ETrainWarningMessageCode;

export function isTrainWarningMessageCode(
    candidate: string,
): candidate is ETrainWarningMessageCode {
    return Object.values(ETrainWarningMessageCode).some(v => v === candidate);
}
