export enum ETrainApiOrderErrorCode {
    NO_PLACES = 'NO_PLACES',
    INVALID_BONUS_CARD = 'INVALID_BONUS_CARD',
    NAME_REQUIRED_LATIN_LETTERS = 'NAME_REQUIRED_LATIN_LETTERS',
    TARIFF_ERROR = 'TARIFF_ERROR',
    TRY_LATER = 'TRY_LATER',
    TOO_LATE = 'TOO_LATE',
    INVALID_DOCUMENT_NUMBER = 'INVALID_DOCUMENT_NUMBER',
    TOO_LATE_FOR_ORDER = 'TOO_LATE_FOR_ORDER',
    CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE = 'CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE',
    REBOOKING_FAILED = 'REBOOKING_FAILED',
    UNKNOWN_PARTNER_ERROR = 'UNKNOWN_PARTNER_ERROR',
}

interface ITrainApiOrderNoPlacesError {
    code: ETrainApiOrderErrorCode.NO_PLACES;
}

interface ITrainApiOrderInvalidBonusCardError {
    code: ETrainApiOrderErrorCode.INVALID_BONUS_CARD;
}

interface ITrainApiOrderNameRequiredLatinLettersError {
    code: ETrainApiOrderErrorCode.NAME_REQUIRED_LATIN_LETTERS;
}

interface ITrainApiOrderTariffError {
    code: ETrainApiOrderErrorCode.TARIFF_ERROR;
}

interface ITrainApiOrderTryLetterError {
    code: ETrainApiOrderErrorCode.TRY_LATER;
}

interface ITrainApiOrderTooLateError {
    code: ETrainApiOrderErrorCode.TOO_LATE;
}

interface ITrainApiOrderInvalidDocumentNumberError {
    code: ETrainApiOrderErrorCode.INVALID_DOCUMENT_NUMBER;
    params: {
        passengerIndex: number;
    };
}

interface ITrainApiOrderTooLateForOrderError {
    code: ETrainApiOrderErrorCode.TOO_LATE_FOR_ORDER;
    params: {
        salesClosesBeforeDeparture: string;
        departure: string;
    };
}

interface ITrainApiOrderCitizenshipNotMatchDocumentTypeError {
    code: ETrainApiOrderErrorCode.CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE;
    params: {
        passengerIndex: number;
    };
}

interface ITrainApiOrderRebookingFailedError {
    code: ETrainApiOrderErrorCode.REBOOKING_FAILED;
}

interface ITrainApiOrderUnknownPartnerError {
    code: ETrainApiOrderErrorCode.UNKNOWN_PARTNER_ERROR;
}

export type TTrainApiOrderError =
    | ITrainApiOrderNoPlacesError
    | ITrainApiOrderInvalidBonusCardError
    | ITrainApiOrderNameRequiredLatinLettersError
    | ITrainApiOrderTariffError
    | ITrainApiOrderTryLetterError
    | ITrainApiOrderTooLateError
    | ITrainApiOrderInvalidDocumentNumberError
    | ITrainApiOrderTooLateForOrderError
    | ITrainApiOrderCitizenshipNotMatchDocumentTypeError
    | ITrainApiOrderRebookingFailedError
    | ITrainApiOrderUnknownPartnerError;

const ERROR_CODES = Object.values(ETrainApiOrderErrorCode);

export function isTrainApiOrderError(error: any): error is TTrainApiOrderError {
    return Boolean(error?.code) && ERROR_CODES.includes(error.code);
}
