import {ICookies} from '@yandex-data-ui/core/lib/types';
import {
    IGeobaseProvider,
    TGeobaseLocation,
    TGeobaseRegion,
    TGeobaseTraits,
} from 'server/providers/geoBase/types';

import {IDependencies} from 'server/getContainerConfig';

export class GeobaseApi {
    cookies: ICookies;
    ip: string;
    forwardedFor: string;
    geoBase: IGeobaseProvider;

    constructor({cookies, ip, forwardedFor, geobaseProvider}: IDependencies) {
        this.ip = ip;
        this.forwardedFor = forwardedFor;
        this.cookies = cookies;
        this.geoBase = geobaseProvider;
    }

    getGeoLocation(): Promise<TGeobaseLocation | null> {
        return this.geoBase.pinpointGeolocation({
            x_forwarded_for: this.forwardedFor,
            ip: this.ip,
            x_real_ip: this.ip,
            yandex_gid: parseInt(this.cookies.yandex_gid, 10) || 0,
            allow_yandex: false,
            yp_cookie: this.cookies.yp,
            ys_cookie: this.cookies.ys,
        });
    }

    getRegionsByType(type: number): Promise<TGeobaseRegion[] | null> {
        return this.geoBase.regionsByType(type);
    }

    getRegionById(id: number): Promise<TGeobaseRegion | null | undefined> {
        return this.geoBase.regionById(id);
    }

    findCountry(id: number): Promise<number | null> {
        return this.geoBase.findCountry(id);
    }

    traitsByIp(): Promise<TGeobaseTraits | null> {
        return this.geoBase.traitsByIp(this.ip);
    }
}
