import moment from 'moment';
import IPrice from 'types/common/price/IPrice';
import {
    ICalendarPricesRequest,
    ICalendarPricesResponse,
} from '../types/ICalendarPrices';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import {ROBOT} from 'utilities/dateUtils/formats';

export function getCalendarPricesMock(
    params: ICalendarPricesRequest,
): Promise<ICalendarPricesResponse> {
    const isSecondRequest = Boolean(params.context);
    const dates = getDates(params, isSecondRequest);
    return Promise.resolve({
        prices: dates.map(date => ({date, price: getRandomPrice()})),
        finished: isSecondRequest,
        context: 'test',
    });
}

function getRandomPrice(): IPrice | undefined {
    if (Math.random() > 0.8) {
        return undefined;
    }

    return {
        value: Math.ceil(Math.random() * 20000),
        currency: CurrencyType.RUB,
    };
}

function getDates(
    {startDate, endDate}: ICalendarPricesRequest,
    isSecondRequest: boolean,
): string[] {
    const begin = moment(startDate, ROBOT);
    const end = moment(endDate, ROBOT);
    let currentDate = isSecondRequest ? begin.add(1, 'day') : begin;
    const result = [currentDate.format(ROBOT)];

    while (currentDate.isBefore(end)) {
        currentDate = currentDate.add(2, 'day');
        result.push(currentDate.format(ROBOT));
    }

    return result;
}
