import {IHotelInfo} from '../types/IHotelInfo';
import {EBreadcrumbType} from '../types/IHotelBreadcrumbs';
import {UserReactionType} from 'types/hotels/hotel/IHotelTextReview';
import {
    EHotelGeoFeatureIcon,
    MainAmenityIdType,
} from 'types/hotels/hotel/IHotel';
import {ERefundType} from 'types/hotels/offer/IHotelOfferCancellationInfo';

import {CURRENCY_RUB} from 'utilities/currency/codes';
import {TransportStationType} from 'types/hotels/hotel/ITransportStation';
import {
    ERoomAmenityIcon,
    ERoomAmenityGroupIcon,
    ERoomBedIcon,
    ERoomAreaUnits,
} from 'types/hotels/offer/IHotelRoom';

export const hotelInfo: IHotelInfo = {
    searchParams: {
        adults: 2,
        childrenAges: [1, 2, 3],
        checkinDate: '2019-10-11',
        checkoutDate: '2019-10-13',
    },
    parentRequestId: '123',
    hotel: {
        permalink: '232323233',
        name: 'Отель у Тамары',
        hotelSlug: 'moscow/kosmos',
        address: 'Шеф довезет',
        stars: 5,
        rating: 5,
        nearestStations: [
            {
                id: '1727553521',
                type: TransportStationType.METRO,
                name: 'Измайлово',
                coordinates: {
                    lon: 37.746194055,
                    lat: 55.788446729,
                },
                distanceMeters: 530.258,
                distanceText: '530 м',
                metroLine: {
                    id: '1727497101',
                    name: 'Московское центральное кольцо',
                    color: '#ff4c4c',
                },
            },
        ],
        geoFeature: {
            id: 'city_center_distance',
            icon: EHotelGeoFeatureIcon.CITY_CENTER,
            name: '7,9 км до центра',
        },
        mainAmenities: [
            {
                id: MainAmenityIdType.WI_FI,
                name: 'Модем',
            },
            {
                id: MainAmenityIdType.POOL,
                name: 'Можно пьяным в бассейн',
            },
            {
                id: MainAmenityIdType.CAR_PARK,
                name: 'Парковка',
            },
            {
                id: MainAmenityIdType.AIR_CONDITIONING,
                name: 'Прохладно там где надо',
            },
            {
                id: MainAmenityIdType.GYM,
                name: 'На спортике',
            },
            {
                id: MainAmenityIdType.PAYMENT_BY_CARD,
                name: 'Оплата картой',
            },
            {
                id: MainAmenityIdType.BEACH_LINE,
                name: 'Ещё и пляж недалеко',
            },
        ],
        amenityGroups: [
            {
                id: 'Internet',
                name: 'Интернет',
                amenities: [
                    {
                        id: 'wired_internet',
                        name: 'Интернет',
                    },
                    {
                        id: 'internet access',
                        name: 'Доступ в интернет: в номерах',
                    },
                    {
                        id: 'internet access',
                        name: 'Доступ в интернет: на всей территории отеля',
                    },
                ],
            },
            {
                id: 'services_amenities',
                name: 'Услуги и удобства',
                amenities: [
                    {
                        id: 'pets',
                        name: 'Возможно проживание с животными',
                    },
                    {
                        id: 'cleaning frequency',
                        name: 'Частота уборки: ежедневно',
                    },
                    {
                        id: 'baggage_room',
                        name: 'Камера хранения',
                    },
                    {
                        id: 'transfer',
                        name: 'Трансфер',
                    },
                    {
                        id: 'room service',
                        name: 'Обслуживание номеров',
                    },
                    {
                        id: 'restrictions on living with animals',
                        name: 'Ограничения проживания с животными: ограничения по весу',
                    },
                    {
                        id: 'around the clock front desk',
                        name: 'Круглосуточная стойка регистрации',
                    },
                    {
                        id: 'public area',
                        name: 'Лобби/public area',
                    },
                    {
                        id: 'atm',
                        name: 'Банкомат',
                    },
                    {
                        id: 'free transfer',
                        name: 'Трансфер: до/от аэропорта',
                    },
                    {
                        id: 'heating',
                        name: 'Отопление',
                    },
                    {
                        id: 'hairdresser',
                        name: 'Парикмахерская',
                    },
                    {
                        id: 'shared toilet',
                        name: 'Общий туалет',
                    },
                    {
                        id: 'dry_cleaning',
                        name: 'Химчистка',
                    },
                    {
                        id: 'pharmacy',
                        name: 'Аптека',
                    },
                    {
                        id: 'laundry',
                        name: 'Прачечная',
                    },
                    {
                        id: 'type of transfer',
                        name: 'Тип трансфера: платный',
                    },
                    {
                        id: 'safe',
                        name: 'Сейф',
                    },
                    {
                        id: 'safe type',
                        name: 'Тип сейфа: в номере',
                    },
                    {
                        id: 'safe type',
                        name: 'Тип сейфа: у администратора',
                    },
                    {
                        id: 'vending machines with snacks',
                        name: 'Автоматы со снэками',
                    },
                    {
                        id: 'hire',
                        name: 'Прокат: машин',
                    },
                    {
                        id: 'concierge service',
                        name: 'Консьерж-сервис',
                    },
                    {
                        id: 'banquet hall',
                        name: 'Банкетный зал',
                    },
                    {
                        id: 'currency_exchange',
                        name: 'Обмен валюты',
                    },
                ],
            },
            {
                id: 'in-room_amenities',
                name: 'Удобства в номерах',
                amenities: [
                    {
                        id: 'non smoking rooms',
                        name: 'Номера для некурящих',
                    },
                    {
                        id: 'refrigerator',
                        name: 'Холодильник',
                    },
                    {
                        id: 'rooms with soundproofing',
                        name: 'Номера со звукоизоляцией',
                    },
                    {
                        id: 'hairdryer',
                        name: 'Фен',
                    },
                    {
                        id: 'TV in room',
                        name: 'Телевизор в номере',
                    },
                    {
                        id: 'bathrobe',
                        name: 'Халат',
                    },
                    {
                        id: 'slippers',
                        name: 'Тапочки',
                    },
                    {
                        id: 'iron',
                        name: 'Утюг',
                    },
                    {
                        id: 'cleaning',
                        name: 'Уборка',
                    },
                    {
                        id: 'combined rooms',
                        name: 'Совмещённые номера',
                    },
                ],
            },
            {
                id: 'dining',
                name: 'Питание',
                amenities: [
                    {
                        id: 'cafe',
                        name: 'Кафе',
                    },
                    {
                        id: 'has_restaurant',
                        name: 'Ресторан',
                    },
                    {
                        id: 'number of bars',
                        name: 'Количество баров: 3',
                    },
                    {
                        id: 'number of restaurants',
                        name: 'Количество ресторанов: 3',
                    },
                    {
                        id: 'has_bar',
                        name: 'Бар',
                    },
                    {
                        id: 'poolside bar',
                        name: 'Бар у бассейна',
                    },
                ],
            },
            {
                id: 'wellness',
                name: 'Красота и здоровье',
                amenities: [
                    {
                        id: 'solarium',
                        name: 'Солярий',
                    },
                    {
                        id: 'bath',
                        name: 'Купальня',
                    },
                    {
                        id: 'massage_services',
                        name: 'Массаж',
                    },
                    {
                        id: 'sauna',
                        name: 'Сауна',
                    },
                    {
                        id: 'beauty_salon',
                        name: 'Салон красоты',
                    },
                    {
                        id: 'hammam',
                        name: 'Хаммам',
                    },
                    {
                        id: 'spa',
                        name: 'Spa',
                    },
                ],
            },
            {
                id: 'activities',
                name: 'Спорт и развлечения',
                amenities: [
                    {
                        id: 'pool_type',
                        name: 'Тип бассейна: крытый',
                    },
                    {
                        id: 'pool_type',
                        name: 'Тип бассейна: с подогревом',
                    },
                ],
            },
            {
                id: 'children',
                name: 'Детям',
                amenities: [
                    {
                        id: 'baby cots',
                        name: 'Детские кроватки/люльки',
                    },
                    {
                        id: 'kids_pool',
                        name: 'Детский бассейн',
                    },
                ],
            },
            {
                id: 'business_services',
                name: 'Бизнес-услуги',
                amenities: [
                    {
                        id: 'business center equipment',
                        name: 'Оснащение бизнес-центра: ксерокопирование',
                    },
                    {
                        id: 'business center',
                        name: 'Бизнес-центр',
                    },
                    {
                        id: 'has_conference_halls',
                        name: 'Конференц-зал',
                    },
                    {
                        id: 'meeting room',
                        name: 'Переговорная',
                    },
                ],
            },
            {
                id: 'hotel_ infrastructure',
                name: 'Инфраструктура',
                amenities: [
                    {
                        id: 'parking type',
                        name: 'Тип парковки: платная',
                    },
                    {
                        id: 'elevator',
                        name: 'Лифт',
                    },
                ],
            },
            {
                id: 'general_information',
                name: 'Общая информация об отеле',
                amenities: [
                    {
                        id: 'year_of_foundation',
                        name: 'Дата постройки: 1980',
                    },
                    {
                        id: 'check in',
                        name: 'Время заезда: 15:00',
                    },
                    {
                        id: 'check out',
                        name: 'Время выезда: 12:00',
                    },
                    {
                        id: 'reconstruction_year',
                        name: 'Дата реконструкции: 2015',
                    },
                    {
                        id: 'facilities for disabled people',
                        name: 'Удобства для людей с ограниченными возможностями',
                    },
                ],
            },
            {
                id: 'accessibility',
                name: 'Доступность',
                amenities: [
                    {
                        id: 'elevator_wheelchair_accessible',
                        name: 'Лифт',
                    },
                ],
            },
            {
                id: 'general_info_eat',
                name: 'Общая информация',
                amenities: [
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: скидки на услуги льготным категориям',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: предоплата',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: наличными',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: оплата картой',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: электронными деньгами',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: банковским переводом',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: безналичная',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: онлайн',
                    },
                    {
                        id: 'payment_method',
                        name: 'Способ оплаты: QR-код',
                    },
                    {
                        id: 'breakfast',
                        name: 'Завтрак',
                    },
                ],
            },
            {
                id: 'general_info_hotel',
                name: 'Общая информация',
                amenities: [
                    {
                        id: 'type_food',
                        name: 'Питание: по меню',
                    },
                    {
                        id: 'type_food',
                        name: 'Питание: полупансион',
                    },
                    {
                        id: 'type_food',
                        name: 'Питание: только завтрак (шведский стол)',
                    },
                    {
                        id: 'type_food',
                        name: 'Питание: английский завтрак',
                    },
                    {
                        id: 'type_food',
                        name: 'Питание: американский завтрак',
                    },
                    {
                        id: 'type_food',
                        name: 'Питание: континентальный завтрак',
                    },
                ],
            },
            {
                id: 'prices_eat',
                name: 'Цены',
                amenities: [
                    {
                        id: 'price_category',
                        name: 'Цены: средние',
                    },
                ],
            },
        ],
        category: {
            id: '123',
            name: 'Хостел',
        },
        totalTextReviewCount: 10,
        totalImageCount: 200,
        images: [
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/5245944/2a0000017af74867eacf0988f8a498a7b4b1/%s',
                id: 'urn:yandex:sprav:photo:Am02gCMe9xtaBslM_5WZzIZ0fG6Ke7',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 23,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 34,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 46,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 68,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 137,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 228,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 364,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 466,
                        width: 1024,
                    },
                    {
                        size: 'XXXL',
                        height: 583,
                        width: 1280,
                    },
                    {
                        size: 'orig',
                        height: 583,
                        width: 1280,
                    },
                ],
                tags: ['Interior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/223006/2a0000015b1c469b506eefe9073dd2c2b8c0/%s',
                id: 'urn:yandex:sprav:photo:431328',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/5272526/2a00000181ae599f68e5f689adf455606382/%s',
                id: 'urn:yandex:sprav:photo:5272526-2a00000181ae599f68e5f689adf455606382',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 50,
                        width: 33,
                    },
                    {
                        size: 'XXS',
                        height: 75,
                        width: 50,
                    },
                    {
                        size: 'XS',
                        height: 100,
                        width: 67,
                    },
                    {
                        size: 'S',
                        height: 150,
                        width: 100,
                    },
                    {
                        size: 'M',
                        height: 300,
                        width: 200,
                    },
                    {
                        size: 'L',
                        height: 500,
                        width: 333,
                    },
                    {
                        size: 'XL',
                        height: 800,
                        width: 533,
                    },
                    {
                        size: 'XXL',
                        height: 1024,
                        width: 682,
                    },
                    {
                        size: 'XXXL',
                        height: 1024,
                        width: 682,
                    },
                    {
                        size: 'orig',
                        height: 1024,
                        width: 682,
                    },
                ],
                tags: [],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/4824927/2a00000181ae599fbedcf4bc9016e77024cd/%s',
                id: 'urn:yandex:sprav:photo:4824927-2a00000181ae599fbedcf4bc9016e77024cd',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 33,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 50,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 67,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 100,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 200,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 333,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 533,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 682,
                        width: 1024,
                    },
                    {
                        size: 'orig',
                        height: 853,
                        width: 1280,
                    },
                ],
                tags: [],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/247136/2a0000015b1c47b5cefd29da1cc3e3937906/%s',
                id: 'urn:yandex:sprav:photo:433129',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/5965316/2a00000181ae59a0220ecf51aaff726a8930/%s',
                id: 'urn:yandex:sprav:photo:5965316-2a00000181ae59a0220ecf51aaff726a8930',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 33,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 50,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 67,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 100,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 200,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 333,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 533,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 682,
                        width: 1024,
                    },
                    {
                        size: 'XXXL',
                        height: 853,
                        width: 1280,
                    },
                    {
                        size: 'orig',
                        height: 853,
                        width: 1280,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/247136/2a0000015b1c4843a17e2ef227701ba0c34a/%s',
                id: 'urn:yandex:sprav:photo:434198',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/5307539/2a00000181ae59a09229a8a73e5497ae9272/%s',
                id: 'urn:yandex:sprav:photo:5307539-2a00000181ae59a09229a8a73e5497ae9272',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 33,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 50,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 67,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 100,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 200,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 333,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 533,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 682,
                        width: 1024,
                    },
                    {
                        size: 'XXXL',
                        height: 853,
                        width: 1280,
                    },
                    {
                        size: 'orig',
                        height: 853,
                        width: 1280,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/5475658/2a00000181ae59a15ba72e5db90991eadf5d/%s',
                id: 'urn:yandex:sprav:photo:5475658-2a00000181ae59a15ba72e5db90991eadf5d',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 23,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 34,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 45,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 68,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 135,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 225,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 360,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 461,
                        width: 1024,
                    },
                    {
                        size: 'XXXL',
                        height: 576,
                        width: 1280,
                    },
                    {
                        size: 'orig',
                        height: 576,
                        width: 1280,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/6311095/2a00000181ae59a0f957fde9f97cb43a73e1/%s',
                id: 'urn:yandex:sprav:photo:6311095-2a00000181ae59a0f957fde9f97cb43a73e1',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 32,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 48,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 64,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 97,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 193,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 322,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 516,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 660,
                        width: 1024,
                    },
                    {
                        size: 'XXXL',
                        height: 825,
                        width: 1280,
                    },
                    {
                        size: 'orig',
                        height: 825,
                        width: 1280,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/374295/2a0000015b1c4b5e24326d13d3ffb16c017a/%s',
                id: 'urn:yandex:sprav:photo:440143',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: ['Exterior'],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/216588/2a0000015b1c4bdac9b5e5129d610847e9c4/%s',
                id: 'urn:yandex:sprav:photo:440348',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: [],
            },
            {
                urlTemplate:
                    'https://avatars.mds.yandex.net/get-altay/216588/2a0000015b1c4cfcc964e07c0ee23332aed2/%s',
                id: 'urn:yandex:sprav:photo:442235',
                sizes: [
                    {
                        size: 'XXXS',
                        height: 27,
                        width: 50,
                    },
                    {
                        size: 'XXS',
                        height: 41,
                        width: 75,
                    },
                    {
                        size: 'XS',
                        height: 55,
                        width: 100,
                    },
                    {
                        size: 'S',
                        height: 82,
                        width: 150,
                    },
                    {
                        size: 'M',
                        height: 164,
                        width: 300,
                    },
                    {
                        size: 'L',
                        height: 274,
                        width: 500,
                    },
                    {
                        size: 'XL',
                        height: 438,
                        width: 800,
                    },
                    {
                        size: 'XXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'XXXL',
                        height: 460,
                        width: 840,
                    },
                    {
                        size: 'orig',
                        height: 460,
                        width: 840,
                    },
                ],
                tags: ['Interior'],
            },
        ],
        coordinates: {
            lat: 55.784774,
            lon: 37.623626,
        },
        isFavorite: false,
    },
    hotelDescription: {
        text: 'У Гули все самое лучшее.',
    },
    breadcrumbs: {
        geoRegions: [
            {
                geoId: 213,
                linguistics: {
                    ablativeCase: '',
                    accusativeCase: 'Москву',
                    dativeCase: 'Москве',
                    directionalCase: '',
                    genitiveCase: 'Москвы',
                    instrumentalCase: 'Москвой',
                    locativeCase: '',
                    nominativeCase: 'Москва',
                    preposition: 'в',
                    prepositionalCase: 'Москве',
                },
            },
        ],
        items: [
            {
                breadcrumbType: EBreadcrumbType.GEO_REGION_BREADCRUMB,
                geoId: 1,
                slug: 'moscow-oblast',
                linguistics: {
                    ablativeCase: '',
                    accusativeCase: 'Подмосковье',
                    dativeCase: 'Подмосковью',
                    directionalCase: '',
                    genitiveCase: 'Подмосковье',
                    instrumentalCase: 'Подмосковье',
                    locativeCase: '',
                    nominativeCase: 'Подмосковье',
                    preposition: 'в',
                    prepositionalCase: 'Подмосковье',
                },
            },
            {
                breadcrumbType: EBreadcrumbType.GEO_REGION_BREADCRUMB,
                geoId: 213,
                slug: 'moscow',
                linguistics: {
                    ablativeCase: '',
                    accusativeCase: 'Москву',
                    dativeCase: 'Москве',
                    directionalCase: '',
                    genitiveCase: 'Москвы',
                    instrumentalCase: 'Москвой',
                    locativeCase: '',
                    nominativeCase: 'Москва',
                    preposition: 'в',
                    prepositionalCase: 'Москве',
                },
            },
            {
                breadcrumbType: EBreadcrumbType.HOTEL_BREADCRUMB,
                name: 'У Тамары',
                slug: 'moscow/cosmos-moscow-vdnh-hotel',
            },
        ],
    },
    seoBreadcrumbs: {
        geoRegions: [],
        items: [],
    },
    offersInfo: {
        offerSearchProgress: {
            finished: false,
            partnersTotal: 10,
            partnersComplete: 10,
        },
        operatorById: {
            '1': {
                id: 'Yandex',
                name: 'Яндекс Путешествия',
                iconUrl:
                    'https://yastatic.net/s3/travel-indexer/icons/travel.svg',
                greenUrl: '',
            },
            '2': {
                id: 'Booking',
                name: 'Booking.com',
                iconUrl:
                    'https://yastatic.net/s3/travel-indexer/icons/booking.svg',
                greenUrl: '',
            },
            '3': {
                id: 'Agoda',
                name: 'Agoda.com',
                iconUrl:
                    'https://yastatic.net/s3/travel-indexer/icons/agoda.svg',
                greenUrl: '',
            },
        },
        rooms: [
            {
                id: '3951579e2881b550e01f5ca33e562392',
                name: 'Стандартный',
                description:
                    'Уютный классический однокомнатный номер, в котором созданы условия для работы и отдыха, с бесплатным Wi-Fi и прекрасными видами на ВДНХ, Останкинскую башню и городские пейзажи Москвы. \n\nПросим обратить внимание, что предпочитаемый тип кроватей – две односпальные или большая двуспальная - не гарантируется. Ваши пожелания могут быть учтены при наличии номеров с указанным типом кровати на момент заселения.',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3413112/2a0000017aefa0027a04cfd308281d659087/%s',
                        id: '3413112-2a0000017aefa0027a04cfd308281d659087',
                        sizes: [
                            {
                                size: 'L',
                                height: 335,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 201,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 535,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 685,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 857,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1614,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1614,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3413112/2a0000017aefa002666425201cd9523cb164/%s',
                        id: '3413112-2a0000017aefa002666425201cd9523cb164',
                        sizes: [
                            {
                                size: 'L',
                                height: 336,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 201,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 537,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 687,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 859,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1609,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1609,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3413112/2a0000017aefa0027a832e91eb7e0ee25267/%s',
                        id: '3413112-2a0000017aefa0027a832e91eb7e0ee25267',
                        sizes: [
                            {
                                size: 'L',
                                height: 341,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 205,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 102,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 545,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 68,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 698,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 873,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1584,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1584,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3595101/2a0000017aefa0026b658f1910a97a8c4fa7/%s',
                        id: '3595101-2a0000017aefa0026b658f1910a97a8c4fa7',
                        sizes: [
                            {
                                size: 'L',
                                height: 328,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 197,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 99,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 526,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 66,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 673,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 49,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 841,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1644,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1644,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'television:yes',
                        icon: ERoomAmenityIcon.TELEVISION_YES,
                        name: 'Телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'heating:true',
                                icon: 'heating',
                                name: 'Отопление',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:24',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 24',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'chair:true',
                                icon: 'chair',
                                name: 'Стул',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'wardrobe-or-closet:true',
                                icon: 'wardrobe-or-closet',
                                name: 'Стенной шкаф или гардероб',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                    {
                        id: '973f0bef0be07f58f23701d299c8b34d',
                        configuration: [
                            {
                                id: 'single_bed',
                                icon: ERoomBedIcon.SINGLE_BED,
                                nameInitialForm: 'односпальная кровать',
                                nameInflectedForm: 'односпальные кровати',
                                quantity: 2,
                            },
                        ],
                    },
                ],
                area: {
                    value: 24,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: '7b550fe42c4df92e2d045c2bfe1e2e11',
                name: 'Повышенной комфортности',
                description:
                    'Однокомнатный комфортабельный номер, оснащенный современной удобной мебелью, с бесплатным Wi-Fi и великолепными видами на Москву. Тщательно подобранный интерьер создает атмосферу уюта. Площадь: 24 кв.м. \nПросим обратить внимание, что предпочитаемый тип кроватей – две односпальные или большая двуспальная - не гарантируется. Ваши пожелания могут быть учтены при наличии номеров с указанным типом кровати на момент заселения.',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d068857944e3b7d8628b1891/%s',
                        id: '3520778-2a0000017af4d068857944e3b7d8628b1891',
                        sizes: [
                            {
                                size: 'L',
                                height: 346,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 207,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 104,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 553,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 69,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 708,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 885,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1562,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1562,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3613454/2a0000017af4d0674628568ad4508d99103e/%s',
                        id: '3613454-2a0000017af4d0674628568ad4508d99103e',
                        sizes: [
                            {
                                size: 'L',
                                height: 342,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 205,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 103,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 548,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 68,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 701,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 876,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1578,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1578,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3597973/2a0000017af4d067346d2d27bef2f060411c/%s',
                        id: '3597973-2a0000017af4d067346d2d27bef2f060411c',
                        sizes: [
                            {
                                size: 'L',
                                height: 362,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 217,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 109,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 579,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 72,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 741,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 54,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 927,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 36,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1492,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1492,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d06884ffb524171483d14716/%s',
                        id: '3520778-2a0000017af4d06884ffb524171483d14716',
                        sizes: [
                            {
                                size: 'L',
                                height: 364,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 219,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 109,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 583,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 73,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 746,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 55,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 933,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 36,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1482,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1482,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'air-conditioning:in-room-climate-control-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер (с климат‑контролем)',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:24',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 24',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'chair:true',
                                icon: 'chair',
                                name: 'Стул',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'hangers:true',
                                icon: 'hangers',
                                name: 'Вешалки',
                            },
                            {
                                id: 'wardrobe-or-closet:true',
                                icon: 'wardrobe-or-closet',
                                name: 'Стенной шкаф или гардероб',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                            {
                                id: 'mini-fridge:true',
                                icon: 'mini-fridge',
                                name: 'Мини‑холодильник',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                    {
                        id: '973f0bef0be07f58f23701d299c8b34d',
                        configuration: [
                            {
                                id: 'single_bed',
                                icon: ERoomBedIcon.SINGLE_BED,
                                nameInitialForm: 'односпальная кровать',
                                nameInflectedForm: 'односпальные кровати',
                                quantity: 2,
                            },
                        ],
                    },
                ],
                area: {
                    value: 24,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: '8e35c58640416b9b0acf06d989b96999',
                name: 'Бизнес',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3595101/2a0000017af4d0691343643d5ae20b7b723f/%s',
                        id: '3595101-2a0000017af4d0691343643d5ae20b7b723f',
                        sizes: [
                            {
                                size: 'L',
                                height: 326,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 196,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 98,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 522,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 65,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 668,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 49,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 835,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1656,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1656,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d06b9f51be8dd8cb9bfdb2a1/%s',
                        id: '3520778-2a0000017af4d06b9f51be8dd8cb9bfdb2a1',
                        sizes: [
                            {
                                size: 'L',
                                height: 320,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 192,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 96,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 513,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 64,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 656,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 48,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 820,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 32,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1685,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1685,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d06b9dd34289fd5f31c2a693/%s',
                        id: '3728360-2a0000017af4d06b9dd34289fd5f31c2a693',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d06f5ed6065109ee45a19e5b/%s',
                        id: '3728360-2a0000017af4d06f5ed6065109ee45a19e5b',
                        sizes: [
                            {
                                size: 'L',
                                height: 393,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 236,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 118,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 628,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 79,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 804,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 59,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 1005,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 39,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1375,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1375,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3613681/2a0000017af4d06ba0ff3add8a2e7e69bdd6/%s',
                        id: '3613681-2a0000017af4d06ba0ff3add8a2e7e69bdd6',
                        sizes: [
                            {
                                size: 'L',
                                height: 344,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 206,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 103,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 550,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 69,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 704,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 880,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1571,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1571,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:24',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 24',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'chair:true',
                                icon: 'chair',
                                name: 'Стул',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'hangers:true',
                                icon: 'hangers',
                                name: 'Вешалки',
                            },
                            {
                                id: 'wardrobe-or-closet:true',
                                icon: 'wardrobe-or-closet',
                                name: 'Стенной шкаф или гардероб',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'bathroom-with-wc:true',
                                icon: 'bathroom-with-wc',
                                name: 'Санузел',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'hygienic-aids:true',
                                icon: 'hygienic-aids',
                                name: 'Гигиенические средства',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                            {
                                id: 'toiletry:true',
                                icon: 'toiletry',
                                name: 'Туалетные средства',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                    {
                        id: '973f0bef0be07f58f23701d299c8b34d',
                        configuration: [
                            {
                                id: 'single_bed',
                                icon: ERoomBedIcon.SINGLE_BED,
                                nameInitialForm: 'односпальная кровать',
                                nameInflectedForm: 'односпальные кровати',
                                quantity: 2,
                            },
                        ],
                    },
                ],
                area: {
                    value: 24,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: 'ce437c9d16e5b6dfa6f569210bc1091e',
                name: 'Полулюкс -номер-студио',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3597973/2a0000017af4d067348c2f194ff1923a0c18/%s',
                        id: '3597973-2a0000017af4d067348c2f194ff1923a0c18',
                        sizes: [
                            {
                                size: 'L',
                                height: 337,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 202,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 540,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 691,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 863,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1601,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1601,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d06736159c302c169920e751/%s',
                        id: '3520778-2a0000017af4d06736159c302c169920e751',
                        sizes: [
                            {
                                size: 'L',
                                height: 353,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 212,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 106,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 565,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 71,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 724,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 53,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 905,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1528,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1528,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d06ba3547cbcf210cc9dcc02/%s',
                        id: '3728360-2a0000017af4d06ba3547cbcf210cc9dcc02',
                        sizes: [
                            {
                                size: 'L',
                                height: 353,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 212,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 106,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 565,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 71,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 723,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 53,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 904,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1530,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1530,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d067373c752faa39fe0277ce/%s',
                        id: '3520778-2a0000017af4d067373c752faa39fe0277ce',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'air-conditioning:in-room-climate-control-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер (с климат‑контролем)',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'sleep',
                        icon: 'sleep',
                        name: 'Сон',
                        amenities: [
                            {
                                id: 'sofa-bed:true',
                                icon: 'sofa-bed',
                                name: 'Раскладной диван',
                            },
                        ],
                    },
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'room-size-square-meters:38',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 38',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchairs:true',
                                icon: 'armchairs',
                                name: 'Кресла',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'hangers:true',
                                icon: 'hangers',
                                name: 'Вешалки',
                            },
                            {
                                id: 'wardrobe-or-closet:true',
                                icon: 'wardrobe-or-closet',
                                name: 'Стенной шкаф или гардероб',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'drinking-water:true',
                                icon: 'drinking-water',
                                name: 'Питьевая вода',
                            },
                            {
                                id: 'mini-fridge:true',
                                icon: 'mini-fridge',
                                name: 'Мини‑холодильник',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'hygienic-aids:true',
                                icon: 'hygienic-aids',
                                name: 'Гигиенические средства',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                            {
                                id: 'toiletry:true',
                                icon: 'toiletry',
                                name: 'Туалетные средства',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                    {
                        id: '973f0bef0be07f58f23701d299c8b34d',
                        configuration: [
                            {
                                id: 'single_bed',
                                icon: ERoomBedIcon.SINGLE_BED,
                                nameInitialForm: 'односпальная кровать',
                                nameInflectedForm: 'односпальные кровати',
                                quantity: 2,
                            },
                        ],
                    },
                ],
                area: {
                    value: 38,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: '57bb32c0351a7c6c9d0937222cd896a7',
                name: 'Люкс',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d0688416ac1cbfd66b5da68c/%s',
                        id: '3728360-2a0000017af4d0688416ac1cbfd66b5da68c',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d06bbe4b76e85a47dae9b591/%s',
                        id: '3728360-2a0000017af4d06bbe4b76e85a47dae9b591',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3613454/2a0000017af4d06734f4b6671a611280f450/%s',
                        id: '3613454-2a0000017af4d06734f4b6671a611280f450',
                        sizes: [
                            {
                                size: 'L',
                                height: 330,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 198,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 99,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 528,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 66,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 676,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 49,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 844,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1637,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1637,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d06ba4e7c71c35cdaaa677d4/%s',
                        id: '3520778-2a0000017af4d06ba4e7c71c35cdaaa677d4',
                        sizes: [
                            {
                                size: 'L',
                                height: 349,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 209,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 105,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 558,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 70,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 714,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 893,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1548,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1548,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'bathroom:true',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'air-conditioning:in-room-climate-control-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер (с климат‑контролем)',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'sleep',
                        icon: 'sleep',
                        name: 'Сон',
                        amenities: [
                            {
                                id: 'sofa-bed:true',
                                icon: 'sofa-bed',
                                name: 'Раскладной диван',
                            },
                        ],
                    },
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'dressing-table:true',
                                icon: 'dressing-table',
                                name: 'Туалетный столик',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'living-area:true',
                                icon: 'living-area',
                                name: 'Гостиная зона',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:46',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 46',
                            },
                            {
                                id: 'type-rooms:two_rooms',
                                icon: 'type-rooms',
                                name: 'Две комнаты',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                            {
                                id: 'two-tv:true',
                                icon: 'two-tv',
                                name: 'Два телевизора',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'armchairs:true',
                                icon: 'armchairs',
                                name: 'Кресла',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                            {
                                id: 'set-of-dishes:true',
                                icon: 'set-of-dishes',
                                name: 'Набор посуды',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'trouser-press:true',
                                icon: 'trouser-press',
                                name: 'Пресс для глажения брюк',
                            },
                            {
                                id: 'wardrobe:true',
                                icon: 'wardrobe',
                                name: 'Гардеробная',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                            {
                                id: 'drinking-water:true',
                                icon: 'drinking-water',
                                name: 'Питьевая вода',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'bidet:true',
                                icon: 'bidet',
                                name: 'Биде',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'hygienic-aids:true',
                                icon: 'hygienic-aids',
                                name: 'Гигиенические средства',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                ],
                area: {
                    value: 46,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: 'b587aa605ddf25bb120e5fd6c1153942',
                name: 'Люкс Гранд',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3613454/2a0000017af4d067342f5b14b60461ba0303/%s',
                        id: '3613454-2a0000017af4d067342f5b14b60461ba0303',
                        sizes: [
                            {
                                size: 'L',
                                height: 328,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 197,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 98,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 524,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 66,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 671,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 49,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 839,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1648,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1648,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3595101/2a0000017af4d06ba48a68e591fb13656279/%s',
                        id: '3595101-2a0000017af4d06ba48a68e591fb13656279',
                        sizes: [
                            {
                                size: 'L',
                                height: 375,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 225,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 113,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 600,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 75,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 56,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 960,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 38,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1440,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1440,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3613454/2a0000017af4d06895bb320688c0ff1684aa/%s',
                        id: '3613454-2a0000017af4d06895bb320688c0ff1684aa',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d068f7b5b16b5cf24a413d98/%s',
                        id: '3520778-2a0000017af4d068f7b5b16b5cf24a413d98',
                        sizes: [
                            {
                                size: 'L',
                                height: 337,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 202,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 539,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 690,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 863,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1602,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1602,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d0691009d5b840bb65ff9ad3/%s',
                        id: '3520778-2a0000017af4d0691009d5b840bb65ff9ad3',
                        sizes: [
                            {
                                size: 'L',
                                height: 337,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 202,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 539,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 690,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 862,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1603,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1603,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'bathroom:true',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'air-conditioning:in-room-climate-control-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер (с климат‑контролем)',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'sleep',
                        icon: 'sleep',
                        name: 'Сон',
                        amenities: [
                            {
                                id: 'sofa-bed:true',
                                icon: 'sofa-bed',
                                name: 'Раскладной диван',
                            },
                        ],
                    },
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'dressing-table:true',
                                icon: 'dressing-table',
                                name: 'Туалетный столик',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'living-area:true',
                                icon: 'living-area',
                                name: 'Гостиная зона',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:61',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 61',
                            },
                            {
                                id: 'type-rooms:two_rooms',
                                icon: 'type-rooms',
                                name: 'Две комнаты',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                            {
                                id: 'two-tv:true',
                                icon: 'two-tv',
                                name: 'Два телевизора',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'armchairs:true',
                                icon: 'armchairs',
                                name: 'Кресла',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                            {
                                id: 'set-of-dishes:true',
                                icon: 'set-of-dishes',
                                name: 'Набор посуды',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'trouser-press:true',
                                icon: 'trouser-press',
                                name: 'Пресс для глажения брюк',
                            },
                            {
                                id: 'wardrobe:true',
                                icon: 'wardrobe',
                                name: 'Гардеробная',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                            {
                                id: 'drinking-water:true',
                                icon: 'drinking-water',
                                name: 'Питьевая вода',
                            },
                            {
                                id: 'mini-fridge:true',
                                icon: 'mini-fridge',
                                name: 'Мини‑холодильник',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'additional-bathroom-with-wc:true',
                                icon: 'additional-bathroom-with-wc',
                                name: 'Дополнительный санузел',
                            },
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'bidet:true',
                                icon: 'bidet',
                                name: 'Биде',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'hygienic-aids:true',
                                icon: 'hygienic-aids',
                                name: 'Гигиенические средства',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                            {
                                id: 'toiletry:true',
                                icon: 'toiletry',
                                name: 'Туалетные средства',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                ],
                area: {
                    value: 61,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: '8cff2569b78fdeeff16f948ab14b32ad',
                name: 'Люкс-Гранд Представительский',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d06900bcc913e318e0b44400/%s',
                        id: '3707302-2a0000017af4d06900bcc913e318e0b44400',
                        sizes: [
                            {
                                size: 'L',
                                height: 344,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 207,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 103,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 551,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 69,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 705,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 882,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1568,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1568,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d06ba341c9ced615e6d98b6d/%s',
                        id: '3707302-2a0000017af4d06ba341c9ced615e6d98b6d',
                        sizes: [
                            {
                                size: 'L',
                                height: 335,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 201,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 536,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 686,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 858,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1611,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1611,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3520778/2a0000017af4d06735b02baa6f283be3f233/%s',
                        id: '3520778-2a0000017af4d06735b02baa6f283be3f233',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d06bc1dc9363f258726970dd/%s',
                        id: '3728360-2a0000017af4d06bc1dc9363f258726970dd',
                        sizes: [
                            {
                                size: 'L',
                                height: 348,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 209,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 104,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 557,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 70,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 713,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 891,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1551,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1551,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3597973/2a0000017af4d06b8cc463ffb4af32868a1f/%s',
                        id: '3597973-2a0000017af4d06b8cc463ffb4af32868a1f',
                        sizes: [
                            {
                                size: 'L',
                                height: 337,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 202,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 101,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 539,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 690,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 862,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1603,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1603,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'bathroom:true',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                    },
                    {
                        id: 'air-conditioning:yes',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'sleep',
                        icon: 'sleep',
                        name: 'Сон',
                        amenities: [
                            {
                                id: 'sofa-bed:true',
                                icon: 'sofa-bed',
                                name: 'Раскладной диван',
                            },
                        ],
                    },
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'electronics',
                        icon: 'electronics',
                        name: 'Электроника',
                        amenities: [
                            {
                                id: 'lamp:true',
                                icon: 'lamp',
                                name: 'Светильник',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'dressing-table:true',
                                icon: 'dressing-table',
                                name: 'Туалетный столик',
                            },
                            {
                                id: 'living-area:true',
                                icon: 'living-area',
                                name: 'Гостиная зона',
                            },
                            {
                                id: 'non-smoking:true',
                                icon: 'non-smoking',
                                name: 'Для некурящих',
                            },
                            {
                                id: 'room-size-square-meters:61',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 61',
                            },
                            {
                                id: 'type-rooms:two_rooms',
                                icon: 'type-rooms',
                                name: 'Две комнаты',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                            {
                                id: 'two-tv:true',
                                icon: 'two-tv',
                                name: 'Два телевизора',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'armchairs:true',
                                icon: 'armchairs',
                                name: 'Кресла',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                            {
                                id: 'set-of-dishes:true',
                                icon: 'set-of-dishes',
                                name: 'Набор посуды',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'trouser-press:true',
                                icon: 'trouser-press',
                                name: 'Пресс для глажения брюк',
                            },
                            {
                                id: 'wardrobe-or-closet:true',
                                icon: 'wardrobe-or-closet',
                                name: 'Стенной шкаф или гардероб',
                            },
                            {
                                id: 'wardrobe:true',
                                icon: 'wardrobe',
                                name: 'Гардеробная',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                            {
                                id: 'mineral-water:true',
                                icon: 'mineral-water',
                                name: 'Минеральная вода',
                            },
                            {
                                id: 'mini-fridge:true',
                                icon: 'mini-fridge',
                                name: 'Мини‑холодильник',
                            },
                            {
                                id: 'tea-set:true',
                                icon: 'tea-set',
                                name: 'Чайный набор',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'additional-bathroom-with-wc:true',
                                icon: 'additional-bathroom-with-wc',
                                name: 'Дополнительный санузел',
                            },
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'bathroom-amenities:true',
                                icon: 'bathroom-amenities',
                                name: 'Банные принадлежности',
                            },
                            {
                                id: 'bathroom-with-wc:true',
                                icon: 'bathroom-with-wc',
                                name: 'Санузел',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'bidet:true',
                                icon: 'bidet',
                                name: 'Биде',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'hygienic-aids:true',
                                icon: 'hygienic-aids',
                                name: 'Гигиенические средства',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                            {
                                id: 'toiletry:true',
                                icon: 'toiletry',
                                name: 'Туалетные средства',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                ],
                area: {
                    value: 61,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
            {
                id: '8164fa7cb3f5a0a45564f70185cd5784',
                name: 'Апартаменты',
                description: '',
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d06f5dac53e1a4a1c7b0ca7a/%s',
                        id: '3707302-2a0000017af4d06f5dac53e1a4a1c7b0ca7a',
                        sizes: [
                            {
                                size: 'L',
                                height: 340,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 204,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 102,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 545,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 68,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 697,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 51,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 872,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1586,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1586,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d06f606c9e16040d8eeb9df3/%s',
                        id: '3707302-2a0000017af4d06f606c9e16040d8eeb9df3',
                        sizes: [
                            {
                                size: 'L',
                                height: 320,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 192,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 96,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 513,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 64,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 656,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 48,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 820,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 32,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1685,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1685,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d068359c3c7aba409dfadb8d/%s',
                        id: '3707302-2a0000017af4d068359c3c7aba409dfadb8d',
                        sizes: [
                            {
                                size: 'L',
                                height: 334,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 534,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 684,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 855,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1617,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1617,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d068f871e95bd571f52d4f4a/%s',
                        id: '3707302-2a0000017af4d068f871e95bd571f52d4f4a',
                        sizes: [
                            {
                                size: 'L',
                                height: 344,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 207,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 103,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 551,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 69,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 705,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 882,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 34,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1568,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1568,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3707302/2a0000017af4d06752d8247787a1c13d5369/%s',
                        id: '3707302-2a0000017af4d06752d8247787a1c13d5369',
                        sizes: [
                            {
                                size: 'L',
                                height: 314,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 188,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 94,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 502,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 63,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 643,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 47,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 803,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 31,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1721,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1721,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-travel-rooms/3728360/2a0000017af4d0673339131ab84e0c39f2b6/%s',
                        id: '3728360-2a0000017af4d0673339131ab84e0c39f2b6',
                        sizes: [
                            {
                                size: 'L',
                                height: 322,
                                width: 500,
                            },
                            {
                                size: 'M',
                                height: 193,
                                width: 300,
                            },
                            {
                                size: 'S',
                                height: 97,
                                width: 150,
                            },
                            {
                                size: 'XL',
                                height: 516,
                                width: 800,
                            },
                            {
                                size: 'XS',
                                height: 64,
                                width: 100,
                            },
                            {
                                size: 'XXL',
                                height: 660,
                                width: 1024,
                            },
                            {
                                size: 'XXS',
                                height: 48,
                                width: 75,
                            },
                            {
                                size: 'XXXL',
                                height: 825,
                                width: 1280,
                            },
                            {
                                size: 'XXXS',
                                height: 32,
                                width: 50,
                            },
                            {
                                size: 'optimize',
                                height: 1080,
                                width: 1675,
                            },
                            {
                                size: 'orig',
                                height: 1080,
                                width: 1675,
                            },
                        ],
                        tags: [],
                    },
                ],
                mainAmenities: [
                    {
                        id: 'view:city_view',
                        icon: ERoomAmenityIcon.VIEW_CITY_VIEW,
                        name: 'Вид на город',
                    },
                    {
                        id: 'bathtub:true',
                        icon: ERoomAmenityIcon.BATHTUB,
                        name: 'Ванна',
                    },
                    {
                        id: 'bathroom:true',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                    },
                    {
                        id: 'air-conditioning:central-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Центральное кондиционирование',
                    },
                    {
                        id: 'air-conditioning:in-room-climate-control-air-conditioning',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер (с климат‑контролем)',
                    },
                    {
                        id: 'air-conditioning:yes',
                        icon: ERoomAmenityIcon.AIR_CONDITIONING,
                        name: 'Кондиционер',
                    },
                    {
                        id: 'flat-panel-tv:true',
                        icon: ERoomAmenityIcon.FLAT_PANEL_TV,
                        name: 'Плоский телевизор',
                    },
                    {
                        id: 'wifi:free',
                        icon: ERoomAmenityIcon.WIFI,
                        name: 'Бесплатный Wi‑Fi',
                    },
                ],
                amenityGroups: [
                    {
                        id: 'internet-telephony',
                        icon: ERoomAmenityGroupIcon.INTERNET_TELEPHONY,
                        name: 'Интернет и телефония',
                        amenities: [
                            {
                                id: 'phone:true',
                                icon: 'phone',
                                name: 'Телефон',
                            },
                        ],
                    },
                    {
                        id: 'sleep',
                        icon: 'sleep',
                        name: 'Сон',
                        amenities: [
                            {
                                id: 'orthopedic-mattress:true',
                                icon: 'orthopedic-mattress',
                                name: 'Ортопедический матрас',
                            },
                            {
                                id: 'sofa-bed:true',
                                icon: 'sofa-bed',
                                name: 'Раскладной диван',
                            },
                        ],
                    },
                    {
                        id: 'other',
                        icon: 'other',
                        name: 'Удобства',
                        amenities: [
                            {
                                id: 'carpet-covering:true',
                                icon: 'carpet-covering',
                                name: 'Ковровое покрытие',
                            },
                            {
                                id: 'information-card:true',
                                icon: 'information-card',
                                name: 'Информационная карта, меню',
                            },
                            {
                                id: 'living-area:true',
                                icon: 'living-area',
                                name: 'Гостиная зона',
                            },
                            {
                                id: 'maid-service:true',
                                icon: 'maid-service',
                                name: 'Обслуживание номеров (услуги горничной)',
                            },
                            {
                                id: 'room-size-square-meters:75',
                                icon: 'room-size-square-meters',
                                name: 'Площадь номера кв.м.: 75',
                            },
                            {
                                id: 'type-rooms:two_rooms',
                                icon: 'type-rooms',
                                name: 'Две комнаты',
                            },
                        ],
                    },
                    {
                        id: 'entertainment',
                        icon: 'entertainment',
                        name: 'Развлечения',
                        amenities: [
                            {
                                id: 'satellite-tv-service:true',
                                icon: 'satellite-tv-service',
                                name: 'Спутниковое телевидение',
                            },
                            {
                                id: 'two-tv:true',
                                icon: 'two-tv',
                                name: 'Два телевизора',
                            },
                        ],
                    },
                    {
                        id: 'furniture',
                        icon: ERoomAmenityGroupIcon.FURNITURE,
                        name: 'Мебель',
                        amenities: [
                            {
                                id: 'armchair:true',
                                icon: 'armchair',
                                name: 'Кресло',
                            },
                            {
                                id: 'armchairs:true',
                                icon: 'armchairs',
                                name: 'Кресла',
                            },
                            {
                                id: 'chairs:true',
                                icon: 'chairs',
                                name: 'Стулья',
                            },
                            {
                                id: 'desk:true',
                                icon: 'desk',
                                name: 'Письменный стол',
                            },
                            {
                                id: 'journal-table:true',
                                icon: 'journal-table',
                                name: 'Журнальный столик',
                            },
                            {
                                id: 'mirror:true',
                                icon: 'mirror',
                                name: 'Зеркало',
                            },
                            {
                                id: 'table:true',
                                icon: 'table',
                                name: 'Стол',
                            },
                            {
                                id: 'toilet-table:true',
                                icon: 'toilet-table',
                                name: 'Туалетный столик',
                            },
                        ],
                    },
                    {
                        id: 'kitchen',
                        icon: ERoomAmenityGroupIcon.KITCHEN,
                        name: 'Кухня',
                        amenities: [
                            {
                                id: 'dinner-table:true',
                                icon: 'dinner-table',
                                name: 'Обеденный стол',
                            },
                            {
                                id: 'refrigerator:yes',
                                icon: 'refrigerator',
                                name: 'Холодильник',
                            },
                        ],
                    },
                    {
                        id: 'clothes',
                        icon: ERoomAmenityGroupIcon.CLOTHES,
                        name: 'Уход за одеждой',
                        amenities: [
                            {
                                id: 'wardrobe:true',
                                icon: 'wardrobe',
                                name: 'Гардеробная',
                            },
                        ],
                    },
                    {
                        id: 'food',
                        icon: ERoomAmenityGroupIcon.FOOD,
                        name: 'Питание и напитки',
                        amenities: [
                            {
                                id: 'cooler-on-the-floor:true',
                                icon: 'cooler-on-the-floor',
                                name: 'Кулер на этаже',
                            },
                            {
                                id: 'drinking-water:true',
                                icon: 'drinking-water',
                                name: 'Питьевая вода',
                            },
                            {
                                id: 'mini-fridge:true',
                                icon: 'mini-fridge',
                                name: 'Мини‑холодильник',
                            },
                        ],
                    },
                    {
                        id: 'bathroom',
                        icon: ERoomAmenityGroupIcon.BATHROOM,
                        name: 'Ванная комната',
                        amenities: [
                            {
                                id: 'additional-bathroom-with-wc:true',
                                icon: 'additional-bathroom-with-wc',
                                name: 'Дополнительный санузел',
                            },
                            {
                                id: 'bath-towels:true',
                                icon: 'bath-towels',
                                name: 'Банные полотенца',
                            },
                            {
                                id: 'bathrobes:true',
                                icon: 'bathrobes',
                                name: 'Банные халаты',
                            },
                            {
                                id: 'beauty-aids:true',
                                icon: 'beauty-aids',
                                name: 'Косметические средства',
                            },
                            {
                                id: 'hair-dryer:yes',
                                icon: 'hair-dryer',
                                name: 'Фен',
                            },
                            {
                                id: 'sink:true',
                                icon: 'sink',
                                name: 'Раковина',
                            },
                            {
                                id: 'slippers:true',
                                icon: 'slippers',
                                name: 'Тапочки',
                            },
                            {
                                id: 'toilet-bowl:true',
                                icon: 'toilet-bowl',
                                name: 'Унитаз',
                            },
                        ],
                    },
                ],
                bedGroups: [
                    {
                        id: 'c7093de994ab6be1d426c58e1a97efbc',
                        configuration: [
                            {
                                id: 'double_bed',
                                icon: ERoomBedIcon.DOUBLE_BED,
                                nameInitialForm: 'двуспальная кровать',
                                nameInflectedForm: 'двуспальная кровать',
                                quantity: 1,
                            },
                        ],
                    },
                ],
                area: {
                    value: 75,
                    unit: ERoomAreaUnits.SQUARE_METERS,
                },
                badges: [],
                pansionAggregate: null,
                cancellationInfoAggregate: null,
            },
        ],
        offerCount: 100,
        operatorCount: 10,
        extraVisitAndUserParams: {},
    },
    similarHotelsInfo: {
        offerSearchProgress: {
            finished: true,
            partnersTotal: 10,
            partnersComplete: 10,
        },
        operatorById: {
            '123': {
                id: 'Yandex',
                name: 'Яндекс Путешествия',
                iconUrl: '',
                greenUrl: '',
            },
        },
        hotels: [
            {
                searchIsFinished: true,
                searchedByUser: true,
                hotel: {
                    permalink: '232323233',
                    name: 'Артист',
                    hotelSlug: '23/343',
                    address: 'Ул Добролюбова, 25A, корпус',
                    stars: 5,
                    rating: 5,
                    nearestStations: [],
                    mainAmenities: [
                        {
                            id: MainAmenityIdType.AIR_CONDITIONING,
                            name: 'Химчистка',
                        },
                    ],
                    category: {
                        id: '123',
                        name: 'Хостел',
                    },
                    totalImageCount: 200,
                    totalTextReviewCount: 0,
                    images: [
                        {
                            urlTemplate:
                                'https://avatars.mds.yandex.net/get-altay/216588/2a0000015b169706c2fdae2f1dacfc786c0a/%s',
                            id: '1',
                            sizes: [{height: 100, size: 's', width: 100}],
                            tags: [''],
                        },
                    ],
                    coordinates: {
                        lat: 55.784774,
                        lon: 37.623626,
                    },
                    isFavorite: false,
                },
                offers: [
                    {
                        id: '1',
                        name: 'Стандартный номер с 1 кроватью или 2 креслами и кошками(двумя)',
                        price: {
                            value: 2500,
                            currency: CURRENCY_RUB,
                        },
                        roomId: '12313',
                        operatorId: '123',
                        landingUrl: 'https://booking.com/',
                        cancellationInfo: {
                            hasFreeCancellation: true,
                            refundType: ERefundType.FULLY_REFUNDABLE,
                        },
                        mealType: {
                            id: 'AI',
                            name: 'Завтрак',
                        },
                        offerYandexPlusInfo: {
                            points: 500,
                            eligible: true,
                        },
                    },
                ],
            },
            {
                searchIsFinished: true,
                searchedByUser: false,
                hotel: {
                    permalink: '23232323113',
                    name: 'У Тамары',
                    hotelSlug: '23/343',
                    address: 'Ул Добролюбова, 25A, корпус',
                    stars: 4,
                    rating: 4,
                    nearestStations: [],
                    mainAmenities: [
                        {
                            id: MainAmenityIdType.AIR_CONDITIONING,
                            name: 'Химчистка',
                        },
                    ],
                    category: {
                        id: '123',
                        name: 'Хостел',
                    },
                    totalImageCount: 200,
                    totalTextReviewCount: 0,
                    images: [
                        {
                            urlTemplate:
                                'https://avatars.mds.yandex.net/get-altay/216588/2a0000015b169706c2fdae2f1dacfc786c0a/%s',
                            id: '1',
                            sizes: [{height: 100, size: 's', width: 100}],
                            tags: [''],
                        },
                    ],
                    coordinates: {
                        lat: 55.784774,
                        lon: 37.623626,
                    },
                    isFavorite: false,
                },
                offers: [
                    {
                        id: '1',
                        name: 'Стандартный номер с 1 кроватью или 2 креслами и кошками(двумя)',
                        price: {
                            value: 25000,
                            currency: CURRENCY_RUB,
                        },
                        roomId: '12313',
                        operatorId: '123',
                        landingUrl: 'https://booking.com/',
                        cancellationInfo: {
                            hasFreeCancellation: true,
                            refundType: ERefundType.FULLY_REFUNDABLE,
                        },
                        mealType: {
                            id: 'AI',
                            name: 'Завтрак',
                        },
                        offerYandexPlusInfo: {
                            points: 3000,
                            eligible: true,
                        },
                    },
                ],
            },
            {
                searchIsFinished: true,
                searchedByUser: false,
                hotel: {
                    permalink: '23223323233',
                    name: 'Гуля',
                    hotelSlug: '23/343',
                    address: 'Ул Добролюбова, 25A, корпус',
                    stars: 1,
                    rating: 2,
                    nearestStations: [],
                    mainAmenities: [
                        {
                            id: MainAmenityIdType.AIR_CONDITIONING,
                            name: 'Химчистка',
                        },
                    ],
                    category: {
                        id: '123',
                        name: 'Хостел',
                    },
                    totalImageCount: 200,
                    totalTextReviewCount: 0,
                    images: [
                        {
                            urlTemplate:
                                'https://avatars.mds.yandex.net/get-altay/216588/2a0000015b169706c2fdae2f1dacfc786c0a/%s',
                            id: '1',
                            sizes: [{height: 100, size: 's', width: 100}],
                            tags: [''],
                        },
                    ],
                    coordinates: {
                        lat: 55.784774,
                        lon: 37.623626,
                    },
                    isFavorite: false,
                },
                offers: [
                    {
                        id: '1',
                        name: 'Стандартный номер с 1 кроватью или 2 креслами и кошками(двумя)',
                        price: {
                            value: 250000,
                            currency: CURRENCY_RUB,
                        },
                        roomId: '12313',
                        operatorId: '123',
                        landingUrl: 'https://booking.com/',
                        cancellationInfo: {
                            hasFreeCancellation: false,
                            refundType: ERefundType.FULLY_REFUNDABLE,
                        },
                        mealType: {
                            id: 'AI',
                            name: 'Завтрак',
                        },
                        offerYandexPlusInfo: {
                            points: 1,
                            eligible: false,
                        },
                    },
                ],
            },
        ],
    },
    reviewsInfo: {
        totalTextReviewCount: 10,
        totalKeyPhraseCount: 10,
        hasMore: true,
        textReviews: [
            {
                id: '1',
                text: 'Посетил сразу после Тамары. Все хорошо.',
                author: {
                    name: 'Максимка У',
                    level: 'Приобрел Жигули девятой модели',
                    avatarUrl:
                        'https://avatars.mds.yandex.net//get-yapic/63032/enc-614760c55377e11df1f784866bfe7693a9a35edd2d763c4cfa2cd4e5fa0ecd80/islands-middle',
                    profileUrl: 'https://staff.yandex-team.ru/maxim-urukov',
                },
                updatedAt: '2022-04-25T21:16:28.097Z',
                rating: 4,
                userReaction: UserReactionType.LIKE,
                totalLikeCount: 354,
                totalDislikeCount: 0,
                businessComment: {
                    id: '34',
                    text: 'У нас сам хороший отель в мире, вы обманываете нас...',
                    updatedAt: '2022-04-25T21:16:28.097Z',
                },
            },
            {
                id: '2',
                text: 'Мой второй отель в сети. Промокод "travel_promo" больше не будет работать, теперь он "travelPromo". Скидка 15 рублей.',
                author: {
                    name: 'Михаил Б',
                    level: 'Владелей двух отелей',
                    avatarUrl:
                        'https://avatars.mds.yandex.net//get-yapic/63032/enc-614760c55377e11df1f784866bfe7693a9a35edd2d763c4cfa2cd4e5fa0ecd80/islands-middle',
                    profileUrl: 'https://staff.yandex-team.ru/maxim-urukov',
                },
                updatedAt: '2022-04-25T21:16:28.097Z',
                rating: 5,
                userReaction: UserReactionType.NONE,
                totalLikeCount: 300,
                totalDislikeCount: 299,
                businessComment: {
                    id: '34',
                    text: 'Основал данный отель, поэтому все идеально. Всем быть!',
                    updatedAt: '2022-04-25T21:16:28.097Z',
                },
            },
            {
                id: '3',
                text: 'Был в этом "чудесном" отеле в феврале. Купаться в речке больно, но зато еда горячая. Ещё есть атракциона для детей - покорми курочек. Куриный суп кстати был очень вкусненький. От вокзала до отеля забирает хозяйка на ВАЗ 2106. Цвет баклажан - это определенно плюс. В целом отель понравился, лучше чем было "У Гули"',
                author: {
                    name: 'Максимус Магистерус',
                    level: 'Владелей двух отелей',
                    avatarUrl:
                        'https://avatars.mds.yandex.net//get-yapic/63032/enc-614760c55377e11df1f784866bfe7693a9a35edd2d763c4cfa2cd4e5fa0ecd80/islands-middle',
                    profileUrl: 'https://staff.yandex-team.ru/maxim-urukov',
                },
                updatedAt: '2022-04-25T21:16:28.097Z',
                rating: 3,
                userReaction: UserReactionType.NONE,
                totalLikeCount: 300,
                totalDislikeCount: 299,
            },
            {
                id: '4',
                text: 'Меня зовут Тамара. Гуля моя сестра.',
                updatedAt: '',
                rating: 1,
                userReaction: UserReactionType.DISLIKE,
                totalLikeCount: 0,
                totalDislikeCount: 9999,
                businessComment: {
                    id: '34',
                    text: 'У нас сам хороший отель в мире, вы обманываете нас...',
                    updatedAt: '',
                },
            },
        ],
        keyPhrases: [
            {
                name: 'Промокод от Миши не работает',
                reviewCount: 10,
            },
            {
                name: 'Встречает Гуля и Тамара',
                reviewCount: 100000,
            },
            {
                name: 'Пускают с кошками и собаками',
                reviewCount: 200,
            },
            {
                name: 'Ключи от жигулей 9',
                reviewCount: 1500,
            },
            {
                name: 'Подключили бейджики',
                reviewCount: 123,
            },
        ],
    },
    ratingsInfo: {
        teaser: '89% гостей понравилось расположение',
        featureRatings: [
            {
                id: 'survey_location',
                name: 'Расположение',
                positivePercent: 100,
            },
            {
                id: 'survey_breakfast',
                name: 'Завтрак',
                positivePercent: 77,
            },
            {
                id: 'survey_value_cleanness',
                name: 'Чистота номеров',
                positivePercent: 76,
            },
            {
                id: 'survey_wifi',
                name: 'Качество WiFi',
                positivePercent: 67,
            },
            {
                id: 'survey_service',
                name: 'Качество обслуживания',
                positivePercent: 65,
            },
            {
                id: 'survey_parking',
                name: 'Удобство парковки',
                positivePercent: 62,
            },
            {
                id: 'survey_value_for_money',
                name: 'Соотношение цены и качества',
                positivePercent: 57,
            },
            {
                id: 'survey_pool',
                name: 'Бассейн',
                positivePercent: 5,
            },
        ],
    },
    seoInfo: {
        title: 'Test hotel title',
        description: 'Test hotel description',
        schemaOrg: {
            name: 'Test schemaOrg name',
            image: 'https://avatars.mds.yandex.net/get-altay/1633071/2a000001690c54e04893b57fcbaa7ceed879/orig',
            priceRange: '1p. - 100р.',
            address: 'Test schemaOrg address',
            ratingValue: 1,
            reviewCount: 100,
        },
        openGraph: {
            title: 'Test title',
            description: 'Test description',
            image: 'https://avatars.mds.yandex.net/get-altay/1633071/2a000001690c54e04893b57fcbaa7ceed879/orig',
        },
    },
    extraVisitAndUserParams: {},
};
