/** Типы сортировки отзывов */
export enum ETextReviewRankingType {
    /**
     *  По времени
     */
    TIME = 'byTime',
    /**
     *  По релевантности ("интересные" отзывы в топе)
     */
    RELEVANCE_ORG = 'byRelevanceOrg',
    /**
     *  По убыванию количества положительных лайков
     */
    LIKES_COUNT_DESC = 'byLikesCountDesc',
    /**
     *  По возрастанию рейтинга (от плохого к хорошему)
     */
    RATING_ASC = 'byRatingAsc',
    /**
     *  По убыванию рейтинга (от хорошего к плохому)
     */
    RATING_DESC = 'byRatingDesc',
}

export const isETextReviewRankingType = (
    value: string,
): value is ETextReviewRankingType => {
    return Object.values(ETextReviewRankingType).some(
        enumValue => enumValue === value,
    );
};
