import IPrice from 'types/common/price/IPrice';
import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';

export interface ICalendarPricesRequest extends IHotelIdentifier {
    // Начальная дата поиска цен
    startDate: string;
    // Конечная дата поиска цен
    endDate: string;
    // параметры поиска отеля
    // todo: после задачи на соседние даты тут появится более подробное описание
    // поведения с checking/checkout и без
    checkinDate?: string;
    checkoutDate?: string;
    adults: number;
    childrenAges: number[];
    // при первом запросе передавать не нужно
    // если get_calendar_prices вернул isFinished === false,
    // то при повторном запросе для получения оставшихся цен
    // нужно передать context полученный из первого запроса
    context?: string;
}

export interface ICalendarPricesResponse {
    prices: IPriceInfo[];
    context: string;
    finished: boolean;
}

interface IPriceInfo {
    date: string;
    price?: IPrice;
}
