import {ITextReview} from 'types/hotels/hotel/IHotelTextReview';
import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';

export interface IEditHotelReviewRequest extends IHotelIdentifier {
    /** Идентификатор отзыва */
    reviewId: string;
    /** Список фотографий, которые нужно прикрепить к отзыву */
    reviewImageIds?: string[] | null;
    /** Текст отзыва, может быть пустым
     * Максимальная длина 1000 символов
     */
    reviewText?: string | null;
    /** Рейтинг отеля в отзыве от пользователя от 1 до 5, может быть пустым */
    reviewRating?: number | null;
}

export interface IEditHotelReviewResponse {
    textReview: ITextReview;
}
