import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';

/* Breadcrumbs */
export interface IBreadcrumbs {
    /** Массив хлебных крошек (содержит только IGeoRegion)
     * @deprecated убрать после перехода на breadcrumbs.items
     * */
    geoRegions: IGeoRegion[];
    /** Массив хлебных крошек
     * для SEO-страниц с фильтром также содержит IFilterBreadcrumbs
     * */
    items: TBreadcrumb[];
}

export enum EBreadcrumbType {
    GEO_REGION_BREADCRUMB = 'IGeoRegionBreadcrumb',
    FILTER_BREADCRUMB = 'IFilterBreadcrumb',
    HOTEL_BREADCRUMB = 'IHotelBreadcrumb',
}

export type TBreadcrumb =
    | IGeoRegionBreadcrumb
    | IFilterBreadcrumb
    | IHotelBreadcrumb;

export interface IGeoRegionBreadcrumb extends IGeoRegion {
    breadcrumbType: EBreadcrumbType.GEO_REGION_BREADCRUMB;
}
export interface IFilterBreadcrumb {
    breadcrumbType: EBreadcrumbType.FILTER_BREADCRUMB;
    name: string;
    slug: string;
}

export interface IHotelBreadcrumb {
    breadcrumbType: EBreadcrumbType.HOTEL_BREADCRUMB;
    name: string;
    slug: string;
}
