import {IHotelOrRoomImage} from 'types/hotels/hotel/IHotelImages';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface IHotelImagesQuantitativeParams {
    imageLimit?: number;
    imageOffset?: number;
}

export interface IHotelImagesRequestParams
    extends IHotelImagesQuantitativeParams {
    hotelSlug: HotelSlugType;
    parentRequestId: string;
}

/* 2. SuccessResponse */

export interface IHotelImagesResponse extends IHotelImages {}

export interface IHotelImages {
    totalImageCount: number;
    images: IHotelOrRoomImage[];
}

/* 3. ErrorResponse */

export interface IHotelImagesError extends IBaseErrorResponse {}
