import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {
    IHotelOffer,
    IHotelOfferSearchProgress,
    IRequiredOfferParams,
    IDebugOfferSearchParams,
    IHotelPartnerOffer,
    IAggregatedOfferInfo,
} from 'types/hotels/offer/IHotelOffer';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';
import {OperatorByIdType} from 'types/hotels/offer/IHotelsOperator';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface IHotelOffersInfoRequestParams
    extends IHotelsAttributionParams,
        IRequiredOfferParams,
        Partial<IDebugOfferSearchParams> {
    hotelSlug: HotelSlugType;
    parentRequestId: string;
    full: boolean;
    label?: string;
    token?: string;
    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;
}

/* 2. SuccessResponse */

export interface IHotelOffersInfoResponse {
    offersInfo: IHotelOffersInfo;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
}

export enum EHotelBanner {
    /**
     * Баннер не нужен
     */
    NONE = 'NONE',

    /**
     * Напрямую от отеля
     */
    HOTEL_DIRECT = 'HOTEL_DIRECT',

    /**
     * Кешбек на карту Мир по акции (HOTELS-5171)
     */
    MIR_CASHBACK = 'MIR_CASHBACK',

    /**
     * Если поменять даты, то может быть кешбек на карту Мир по акции (HOTELS-5171)
     */
    POSSIBLE_MIR_CASHBACK = 'POSSIBLE_MIR_CASHBACK',
}

export interface IHotelOffersInfo {
    bannerType?: EHotelBanner;
    offerSearchProgress: IHotelOfferSearchProgress;
    // Агрегированная информация обо всех офферах. Нужна для кнопки "посмотреть все оффера" (на ней либо пишется "от X рублей", либо рядом с ней пишется информация о диапазоне цен и питании).
    aggregatedOfferInfo?: IAggregatedOfferInfo;
    rooms?: IHotelRoom[];
    operatorById: OperatorByIdType;
    offerCount?: number;
    operatorCount?: number;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
    // Новые поля для страницы Meta + boy
    mainOffers?: IHotelOffer[] | null;
    partnerOffers?: IHotelPartnerOffer[] | null;
}

/* 3. ErrorResponse */

export interface IHotelOffersInfoError extends IBaseErrorResponse {}
