import {
    IHotelOfferSearchProgress,
    IRequiredOfferParams,
    IDebugOfferSearchParams,
} from 'types/hotels/offer/IHotelOffer';
import {OperatorByIdType} from 'types/hotels/offer/IHotelsOperator';
import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface ISimilarHotelsInfoRequestParams
    extends IHotelsAttributionParams,
        IRequiredOfferParams,
        Partial<IDebugOfferSearchParams> {
    hotelSlug: HotelSlugType;
    parentRequestId: string;
    similarHotelLimit?: number;
    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;
}

/* 2. SuccessResponse */

export interface ISimilarHotelsInfoResponse {
    similarHotelsInfo: ISimilarHotelsInfo;
}

export interface ISimilarHotelsInfo {
    offerSearchProgress: IHotelOfferSearchProgress;
    hotels: IHotelWithOffers[];
    operatorById: OperatorByIdType;
}

/* 3. ErrorResponse */

export interface ISimilarHotelsInfoError extends IBaseErrorResponse {}
