import {StatusCodes} from '../constants/statusCodes';
import {EOfferStatus} from 'projects/hotels/constants/EOfferStatus';

import {IBreadcrumbs} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {IPromoCampaigns} from 'types/hotels/book/IPromoCampaigns';
import {TInstantDateTimeType} from 'types/common/date/IDate';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';
import {ICancellationInfo} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import IAmenity from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IAmenity';
import EHotelPartnerId from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/EHotelPartnerId';
import {IExtraFeeRate} from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IHotelPriceInfo/IExtraFeeRate';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import IPrice from 'utilities/currency/PriceInterface';

/** TODO: в будующем заменить на server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IImageLink.ts */
export interface IBookImage {
    links: Record<string, {href: string}>;
}

/* Offer beds groups */

export interface IBookOfferBedsGroup {
    description: string;
    id: string;
}

export type TBookOfferBedsGroups = IBookOfferBedsGroup[];

/* Offer room */

export type TBookOfferAmenities = Record<number, IAmenity>;

export interface IBookOfferRoomDescription {
    overview?: string;
}

export interface IBookOfferRoom {
    name: string;
    images: IBookImage[];
    amenities: TBookOfferAmenities;
    descriptions: IBookOfferRoomDescription;
}

/* Offer meal */

export interface IBookOfferMeal {
    id: string;
    name: string;
}

/* Offer price */

export interface IBookOfferPrice {
    amount: string;
    currency: CurrencyType;
}

export interface IBookOfferTaxesAndFeesCharges extends IBookOfferPrice {
    type: string;
}

export interface IBookOfferNightlyCharges {
    hotelBase: IBookOfferPrice;
    taxesAndFees: IBookOfferTaxesAndFeesCharges[];
}

export interface IBookOfferTotalsCharges {
    hotelBase?: IBookOfferPrice;
    taxesAndFees?: IBookOfferPrice[];
    taxesAndFeesSum?: IBookOfferTaxesAndFeesCharges | {};
    totalPrice?: IBookOfferPrice;
    strikeThrough?: IBookOfferPrice;
    discount?: IBookOfferPrice;
    priceAfterPlusWithdraw?: IPrice;
}

export interface IBookOfferHotelCharges {
    nightly: IBookOfferNightlyCharges[];
    totals: IBookOfferTotalsCharges;
}

export interface IBookOfferPriceInfo {
    hotelCharges: Partial<IBookOfferHotelCharges>;
    extraCharges: IExtraFeeRate[];
}

/* Order offer info */

export interface IBookOrderOfferInfo {
    label: string;
    checksum: string;
    sessionKey: string;
    token: string;
}

/* Cancellation info */

export interface IBookOfferRefundableRule {
    price: IBookOfferPrice;
    type: string;
    endDate: string;
    startDate: string;
}

export interface IBookOfferCancellationInfo {
    refundable: boolean;
    highlighted: boolean;
    refundableRules: IBookOfferRefundableRule[];
}

/* Partner hotel info */

export type TBookHotelImages = IBookImage[];

export interface IBookHotelCoordinates {
    lat: number;
    lng: number;
}

export type TBookPartnerHotelAmenities =
    | Record<
          number,
          {
              id: number;
              name: string;
          }
      >
    | {};

export type TBookPartnerHotelRating = {
    rating?: string;
    type?: string;
};

export interface IBookPartnerHotelDescriptions {
    location: string;
    rooms: string;
    dining: string;
    amenities: string;
    businessAmenities: string;
}

export interface IBookPartnerHotelAddress {
    city: string;
    countryCode: string;
    firstLine: string;
    secondLine: string;
}

export interface IBookPartnerHotelInfo {
    hotelName: string;
    hotelType: string;
    images: TBookHotelImages;
    amenities: TBookPartnerHotelAmenities;
    propertyRating: TBookPartnerHotelRating;
    descriptions: Partial<IBookPartnerHotelDescriptions>;
    coordinates: IBookHotelCoordinates;
    address: Partial<IBookPartnerHotelAddress>;
}

export interface IBookHotelSettlement {
    instructions: string;
    optionalCharge: string;
    mandatoryCharge: string;
    policyCheckinInfo: string;
    specialInstructions: string;
}

export interface IBookHotelCheckin {
    beginTime?: string;
    endTime?: string;
}

export interface IBookHotelCheckout {
    endTime?: string;
}

export interface IBookHotelInfo {
    checkin: IBookHotelCheckin;
    checkout: IBookHotelCheckout;
    settlementInfo: IBookHotelSettlement;
    name: string;
    phone: string;
    images: TBookHotelImages;
    rating: number;
    stars: number;
    address: string;
    permalink: number;
    hotelSlug: HotelSlugType;
    partnerHotelName: string;
    imageUrlTemplate: string;
    coordinates: IBookHotelCoordinates;
    breadcrumbs?: IBreadcrumbs;
}

/* Deferred payment schedule */

export interface IBookInitialDeferredPayment {
    amount: IPrice;
    percentage?: number;
}

export interface IBookDeferredPayment {
    amount: IPrice;
    percentage?: number;
    paymentEndsAt: TInstantDateTimeType;
    penaltyIfUnpaid: IPrice;
}

export interface IBookDeferredPaymentSchedule {
    initialPayment: IBookInitialDeferredPayment;
    deferredPayments: IBookDeferredPayment[];
    zeroFirstPayment: boolean;
}

/* Legal info */

export interface IBookLegalInfo {
    source: string;
    name: string;
    ogrn: string;
    registryNumber: string;
    workingHours: string;
    legalAddress: string;
    actualAddress: string;
}

export type TBookLegalInfo = IBookLegalInfo[];

/* Search params */
export interface IBookSearchParams {
    endDate: string;
    startDate: string;
    adults: number;
    childrenAges: number[];
}

/* Result offer info */

export interface IBookOffer {
    partnerId: EHotelPartnerId;
    roomInfo: IBookOfferRoom;
    bedsGroups: TBookOfferBedsGroups;
    mealInfo: IBookOfferMeal;
    offerOrderInfo: IBookOrderOfferInfo;
    priceInfo: IBookOfferPriceInfo;
    refundableInfo?: ICancellationInfo;
    cancellationInfo: IBookOfferCancellationInfo;
    cancellationInfoAll: IBookOfferCancellationInfo;
    partnerHotelInfo: IBookPartnerHotelInfo;
    hotelInfo: IBookHotelInfo;
    legalInfo: TBookLegalInfo;
    searchParams: IBookSearchParams;
    directPartner: boolean;
    promoCampaigns?: IPromoCampaigns;
    deferredPaymentSchedule?: IBookDeferredPaymentSchedule;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
    allGuestsRequired: boolean;
}

/* Fetch request params */

export interface IFetchBookOfferParams {
    token: string;
    label?: string;
    customerIp?: string | string[];
    customerUserAgent?: string;
}

export interface IParsedTokenInfo {
    originalId: string;
    checkinDate: string;
    checkoutDate: string;
    permalink: number;
    partnerId: string;
    generatedAt: string;
    offerId: string;
    tokenId: string;
    occupancy: string;
}

/* Error offer */
export interface IBookOfferNotAvaliableError {
    code: EOfferStatus.OFFER_IS_NOT_AVAILABLE;
    offerInfo: IBookOffer;
}

export interface IBookOfferNotFoundError {
    code: EOfferStatus.OFFER_NOT_FOUND_ERROR;
    tokenInfo: IParsedTokenInfo;
}

export interface IBookOfferCommonError {
    code: EOfferStatus;
}

export type TBookOfferError =
    | IBookOfferNotAvaliableError
    | IBookOfferNotFoundError
    | IBookOfferCommonError;

export interface IBookOfferInfoError {
    error: TBookOfferError;
    statusCode: StatusCodes;
}
