/* eslint-disable camelcase */
import {StatusCodes} from '../constants/statusCodes';

import ILinguistics from 'types/common/ILinguistics';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {TInstantDateTimeType} from 'types/common/date/IDate';
import {IPromoCampaigns} from 'types/hotels/book/IPromoCampaigns';
import {IHotelOfferMeal} from 'types/hotels/offer/IHotelOfferMeal';
import {ICancellationInfo} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';
import IAmenity from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IAmenity';
import IBedGroupInfo from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IBedGroupInfo';
import IFees from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/IFees';
import IRatings from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/IRatings';
import ICheckin from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/ICheckin';
import ICheckout from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/ICheckout';
import IPolicies from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/IPolicies';
import IHotelAddress from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/IHotelAddress';
import {ICoordinates} from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/ICoordinates';
import ICancellationPenalty from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/ICancellationInfo/ICancellationPenalty';
import {
    IBookImage,
    IBookOfferRoom,
    IBookOfferPrice,
    IBookOfferTaxesAndFeesCharges,
    IBookPartnerHotelDescriptions,
} from 'reducers/hotels/bookAndPayPage/offerInfoByToken/types';
import EHotelPartnerId from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/EHotelPartnerId';
import {IExtraFeeRate} from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IHotelPriceInfo/IExtraFeeRate';

import IPrice from 'utilities/currency/PriceInterface';

/* Offer rate */

interface IBookOfferNightlyChargesResponse {
    base: IBookOfferPrice;
    taxesAndFees: IBookOfferTaxesAndFeesCharges[];
}

export interface IBookOfferHotelChargesResponse {
    nightly: IBookOfferNightlyChargesResponse[];
    totals: Partial<{
        base: IBookOfferPrice;
        taxesAndFees: IBookOfferPrice[];
        taxesAndFeesSum: IBookOfferTaxesAndFeesCharges;
        grand: IBookOfferPrice;
        strikeThrough: IBookOfferPrice;
        discount: IBookOfferPrice;
        priceAfterPlusWithdraw: IPrice;
    }>;
}

export interface IBookOfferRateResponse {
    hotelCharges: IBookOfferHotelChargesResponse;
    extraCharges: IExtraFeeRate[];
}

/* Cancellation info */

export interface IBookOfferCancellationInfoResponse {
    refundable: boolean;
    highlighted: boolean;
    penalties: ICancellationPenalty[];
}

/* Partner hotel info */

export interface IPartnerHotelInfoResponse {
    name: string;
    category: {
        name: string;
    };
    ratings: IRatings;
    descriptions: IBookPartnerHotelDescriptions;
    checkin: ICheckin;
    checkout: ICheckout;
    fees: IFees;
    phone: string;
    policies: IPolicies;
    location:
        | {
              coordinates: ICoordinates | {};
          }
        | {};
    address: IHotelAddress;
    amenities: Record<number, IAmenity>;
    images: IBookImage[];
}

/* Basic hotel */

/** TODO команда отелей - тип почти 1:1 совпадает с server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IGeoHotelInfo/IGeoRegion.ts */
export interface IBasicGeoRegion {
    geoId: number;
    linguistics: ILinguistics;
}

export interface IBasicHotelBreadcrumbs {
    geoRegions: IBasicGeoRegion[];
}

export interface IBasicHotelInfoResponse {
    address: string;
    coordinates: ICoordinates;
    imageUrlTemplate: string;
    name: string;
    rating: number;
    stars: number;
    permalink: number;
    hotelSlug: HotelSlugType;
    breadcrumbs?: IBasicHotelBreadcrumbs;
}

/* Deferred payment schedule */

export interface IBookInitialDeferredPaymentResponse {
    name: string;
    amount: IPrice;
    percentage: number;
}

export interface IBookDeferredPaymentResponse {
    name: string;
    amount: IPrice;
    percentage: number;
    paymentEndsAt: TInstantDateTimeType;
    penaltyIfUnpaid: IPrice;
}

export interface IBookDeferredPaymentScheduleResponse {
    initialPayment: IBookInitialDeferredPaymentResponse;
    deferredPayments: IBookDeferredPaymentResponse[];
    zeroFirstPayment: boolean;
}

/* Legal info */

export type TBookLegalInfoResponse = Record<
    string,
    {
        name: string;
        ogrn: string;
        registryNumber: string;
        legalAddress: string;
        actualAddress: string;
        workingHours: string;
    }
>;

/* Request info */

/** TODO: Команде отелей - Почти 1:1 совпадает с server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IHotelSearchRequestInfo.ts */
export interface IBookRequestInfoResponse {
    checkinDate: string;
    checkoutDate: string;
    childAges: number[];
    numAdults: number;
    selectedBedGroupIndex?: number;
}

/* Parsed token  */

/** TODO команда отелей: checkInDate vs checkinDate у IParsedTokenInfo - привести к одному  */
export interface IParsedToken {
    originalId: string;
    checkInDate: string;
    checkOutDate: string;
    permalink: number;
    partnerId: string;
    generatedAt: string;
    offerId: string;
    tokenId: string;
    occupancy: string;
}

/* Result offer info response */

export interface IBookOfferResponse {
    partnerId: EHotelPartnerId;
    label: string;
    checksum: string;
    sessionKey: string;
    travelToken: string;
    bedGroups: IBedGroupInfo[] | null;
    rateInfo: IBookOfferRateResponse;
    refundInfo?: ICancellationInfo;
    cancellationInfo?: IBookOfferCancellationInfoResponse;
    cancellationInfoUnfiltered?: IBookOfferCancellationInfoResponse;
    partnerHotelInfo: IPartnerHotelInfoResponse;
    basicHotelInfo: IBasicHotelInfoResponse;
    partnerRoomInfo: IBookOfferRoom;
    pansionInfo: IHotelOfferMeal;
    legalInfo: TBookLegalInfoResponse;
    requestInfo: IBookRequestInfoResponse;
    directPartner: boolean;
    promoCampaigns?: IPromoCampaigns;
    deferredPaymentSchedule?: IBookDeferredPaymentScheduleResponse | null;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
    allGuestsRequired: boolean;
}

export interface IBookOfferErrorResponse {
    error: string;
    message: string;
    status: StatusCodes;
}

export interface IBookOfferNotFoundErrorResponse
    extends IBookOfferErrorResponse {
    status: StatusCodes.OFFER_NOT_FOUND;
    token: IParsedToken;
}

export interface IBookOfferBadRequestErrorResponse
    extends IBookOfferErrorResponse {
    status: StatusCodes.OFFER_BAD_REQUEST;
    timestamp: string;
    path: string;
}
