/* eslint-disable camelcase */
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {IBookOfferResponse} from './IBookOfferResponse';

export interface ICreateOrderGuest {
    first_name: string;
    last_name: string;
}

export interface IApiAppliedPromoCampaigns {
    yandex_plus?: {
        mode: EYandexPlusApplicationMode;
        points: number;
    };
    white_label?: {
        customer_number?: string;
    };
}

export interface ICreateOrderRequestParams {
    label: string;
    token: string;
    checksum: string;
    customer_email: string;
    customer_phone: string;
    customer_login?: string | null;
    customer_passport_id?: string;
    customer_yandex_uid?: string;
    customer_user_agent?: string | string[];
    customer_ip?: string | string[];
    /**
     * Гости должны быть том же в порядке, как они пришли в IBookOffer.searchParams.
     *
     * Т.е. если нам пришли в офере: {adults: 2, children: [10, 15]}.
     * То при создании заказа гости тут должны быть в таком порядке:
     * [ взрослый, взрослый, ребенок 10 лет, ребенок 15 лет]
     */
    guests: ICreateOrderGuest[];
    selected_bed_group_index: number;
    session_key: string;
    promo_codes?: string[];
    use_deferred_payments?: boolean;

    /** Платежный тестовый контекст */
    payment_test_context_token?: string;
    applied_promo_campaigns?: IApiAppliedPromoCampaigns;
}

export interface ICreateOrderResponse {
    id: string;
}

export interface ICreateOrderErrorResponse {
    orderInfo: IBookOfferResponse;
}
