import {StatusCodes} from '../constants/statusCodes';
import {
    OrderCancellationDetailsFieldType,
    OrderCancellationDetailsReasonType,
} from 'server/api/HotelsBookAPI/constants/orderCancellationDetails';
import {EFiscalReceiptType} from 'projects/hotels/constants/EFiscalReceiptType';

import {TInstantDateTimeType} from 'types/common/date/IDate';
import {IPromoCampaigns} from 'types/hotels/book/IPromoCampaigns';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';
import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';
import {IPromoCodeApplicationResult} from 'types/hotels/book/IApplyPromoCodes';
import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import ValueType from 'utilities/currency/ValueType';
import IPrice from 'utilities/currency/PriceInterface';

import {IBookOffer} from './IBookOffer';

export type TOrderIdType = string;

export type TYandexOrderIdType = string;

export interface IOrderPrice {
    amount: ValueType;
    currency: CurrencyType;
}

export interface IOrderParams {
    orderId: TOrderIdType;
}

export interface IOrderRequestParams {
    id: TOrderIdType;
}

export enum EHotelOrderPaymentType {
    FULL = 'FULL',
    INITIAL = 'INITIAL',
    DEFERRED = 'DEFERRED',
    EXTRA = 'EXTRA',
}

export interface IOrderCurrentPayment {
    amount: IPrice;
    paymentUrl: string;
    type: EHotelOrderPaymentType;
}

export interface IOrderNextPayment {
    amount: IPrice;
    penaltyIfUnpaid: IPrice;
    paymentEndsAt: TInstantDateTimeType;
}

export interface IOrderErrorPayment {
    code: EOriginalPaymentErrorCode;
    amount: IPrice;
}

export interface IOrderPaymentReceipt {
    type: EFiscalReceiptType;
    url: string;
}

export interface IOrderPayment {
    errorCode?: EOriginalPaymentErrorCode;
    paymentUrl?: string;
    receipts?: IOrderPaymentReceipt[];
    current?: IOrderCurrentPayment;
    next?: IOrderNextPayment;
    error?: IOrderErrorPayment;
    amountPaid?: IPrice;
    mayBeStarted?: boolean;
    mayBeCancelled?: boolean;
    usesDeferredPayments?: boolean;
    usesZeroFirstPayment?: boolean;
}

export interface IHotelGuest {
    firstName: string;
    lastName: string;
}

export interface IOrderGuestsInfo {
    customerEmail: string;
    customerPhone: string;
    selectedBedGroupIndex?: number;
    guests: IHotelGuest[];
}

export interface IOrderRefundableInfo {
    penalty?: IOrderPrice;
    refund?: IOrderPrice;
    penaltyIntervalIndex?: number;
    refundDateTime?: string;
}

export interface IOrderConfirmationInfo {
    yandexOrderId: TYandexOrderIdType;
    confirmationId: string;
}

export interface IOrderCancellationDetails {
    reason?: OrderCancellationDetailsReasonType;
    invalidInputDetails?: {
        fieldType: OrderCancellationDetailsFieldType;
    }[];
}

export interface IOrder {
    orderId: TOrderIdType;
    payment: IOrderPayment;
    status: string;
    displayState: EDisplayOrderState;
    guestsInfo: IOrderGuestsInfo;
    refundableInfo: IOrderRefundableInfo;
    confirmationInfo: IOrderConfirmationInfo;
    offerInfo: IBookOffer;
    orderCancellationDetails: IOrderCancellationDetails;
    orderPriceInfo: IOrderPriceInfo | null;
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
    tripId?: string | null;
    canGenerateBusinessTripDoc?: boolean;
}

export interface IOrderPriceInfo {
    price: IPrice;
    originalPrice: IPrice;
    discountAmount: IPrice;
    promoCampaigns: IPromoCampaigns;
    codeApplicationResults: IPromoCodeApplicationResult[];
}

export interface IOrderError {
    statusCode: StatusCodes;
}
