/* eslint-disable camelcase */

import {StatusCodes} from '../constants/statusCodes';

import {TOrderIdType, IOrderPrice} from './IOrder';
import {IOrderPriceResponse} from './IOrderResponse';

export interface IOrderRefundableInfo {
    penalty: IOrderPrice;
    refund: IOrderPrice;
    refundToken: string;
    validUntil: string;
}

export interface IOrderRefundableInfoResponse {
    penalty: IOrderPriceResponse;
    refund: IOrderPriceResponse;
    refund_token: string;
    valid_until: string;
}

export interface IOrderRefundableInfoParams {
    orderId: TOrderIdType;
}

export interface IOrderRefundableInfoRequestParams {
    id: TOrderIdType;
}

export interface IOrderRefundableInfoError {
    statusCode: StatusCodes;
}
